-- ------------------------------------------------------------------------------------------------------------
-- INITIAL DATA FOR JUMPSTART MAX
-- ------------------------------------------------------------------------------------------------------------

delete from Person;

insert into Person(id, firstName, lastName, version)
	values (1, 'Humpty', 'Dumpty', 1);
insert into Person(id, firstName, lastName, version)
	values (2, 'Jack', 'Sprat', 1);
insert into Person(id, firstName, lastName, version)
	values (3, 'Jill', 'Spill', 1);
	
delete from DateStuff;

insert into DateStuff(id, aDate, aTime, aTimestamp, aDateMidnight, aDateTime, 
			aLocalDate, aLocalTime, aLocalDateTime, version)
	values (1, '2001-07-31', '10:35:17', '2001-07-31 10:35:17', '2001-07-31', '2001-07-31 10:35:17', 
			'2001-07-31', '10:35:17', '2001-07-31 10:35:17', 1);

-- ------------------------------------------------------------------------------------------------------------
-- Bootstrap some initial entries into code_group and code, ie. with autocommit and referential integrity turned off.
-- This is necessary because of circular foreign key references between code_group and code.
-- ------------------------------------------------------------------------------------------------------------

set autocommit false;  -- hsqldb
-- set autocommit = false;  -- mysql

set referential_integrity false;  -- hsqldb
-- set foreign_key_checks = false;  -- mysql

delete from user_role;
delete from role;
delete from user;
delete from code;
delete from code_group;

commit;

-- code_group and codes for the "code" table

	insert into code_group(id, status_code, description, short_description, version)
		values	('cod_status', 'cgr_active', 'Code status', 'Status', 1);
	insert into code(id, status_code, code_group_id, display_seq, description, short_description, version)
		values	('cod_active', 'cod_active', 'cod_status', 1, 'Active', 'Active', 1);
	insert into code(id, status_code, code_group_id, display_seq, description, short_description, version)
		values	('cod_inactive', 'cod_active', 'cod_status', 2, 'Inactive', 'Inactive', 1);

-- code_group and codes for the "code_group" table

	insert into code_group(id, status_code, description, short_description, version)
		values	('cgr_status', 'cgr_active', 'Code group status', 'Status', 1);
	insert into code(id, status_code, code_group_id, display_seq, description, short_description, version)
		values	('cgr_active', 'cod_active', 'cgr_status', 1, 'Active', 'Active', 1);
	insert into code(id, status_code, code_group_id, display_seq, description, short_description, version)
		values	('cgr_inactive', 'cod_active', 'cgr_status', 2, 'Inactive', 'Inactive', 1);
		
commit;
set autocommit true;  -- hsqldb
-- set autocommit = true;  -- mysql
set referential_integrity true;  -- hsqldb
-- set foreign_key_checks = true;  -- mysql

-- ------------------------------------------------------------------------------------------------------------
-- Set up remaining initial data
-- ------------------------------------------------------------------------------------------------------------

-- code_group and codes for User.status

	insert into code_group(id, status_code, description, short_description, version)
		values	('usr_status', 'cgr_active', 'User status', 'Status', 1);
	insert into code(id, status_code, code_group_id, display_seq, description, short_description, version)
		values	('usr_active', 'cod_active', 'usr_status', 1, 'Active', 'Active', 1);
	insert into code(id, status_code, code_group_id, display_seq, description, short_description, version)
		values	('usr_inactive', 'cod_active', 'usr_status', 2, 'Inactive', 'Inactive', 1);

-- code_group and codes for User.salutation

	insert into code_group(id, status_code, description, short_description, version)
		values	('usr_salutation', 'cgr_active', 'User salutation', 'Salut', 1);
	insert into code(id, status_code, code_group_id, display_seq, description, short_description, version)
		values	('usr_mr', 'cod_active', 'usr_salutation', 1, 'Mr', 'Mr', 1);
	insert into code(id, status_code, code_group_id, display_seq, description, short_description, version)
		values	('usr_ms', 'cod_active', 'usr_salutation', 2, 'Ms', 'Ms', 1);
	insert into code(id, status_code, code_group_id, display_seq, description, short_description, version)
		values	('usr_miss', 'cod_active', 'usr_salutation', 3, 'Miss', 'Miss', 1);
	insert into code(id, status_code, code_group_id, display_seq, description, short_description, version)
		values	('usr_mrs', 'cod_active', 'usr_salutation', 4, 'Mrs', 'Mrs', 1);

-- code_group and codes for Role.status

	insert into code_group(id, status_code, description, short_description, version)
		values	('rol_status', 'cgr_active', 'Role status', 'Status', 1);
	insert into code(id, status_code, code_group_id, display_seq, description, short_description, version)
		values	('rol_active', 'cod_active', 'rol_status', 1, 'Active', 'Active', 1);
	insert into code(id, status_code, code_group_id, display_seq, description, short_description, version)
		values	('rol_inactive', 'cod_active', 'rol_status', 2, 'Inactive', 'Inactive', 1);

-- code_group and codes for UserRole.status

	insert into code_group(id, status_code, description, short_description, version)
		values	('uro_status', 'cgr_active', 'User role status', 'Status', 1);
	insert into code(id, status_code, code_group_id, display_seq, description, short_description, version)
		values	('uro_active', 'cod_active', 'uro_status', 1, 'Active', 'Active', 1);
	insert into code(id, status_code, code_group_id, display_seq, description, short_description, version)
		values	('uro_inactive', 'cod_active', 'uro_status', 2, 'Inactive', 'Inactive', 1);

-- users and roles

	insert into user(id, login_id, password, salutation_code, first_name, last_name, email_address, expiry_date, status_code, version,
			style_id, show_inspector, date_input_pattern, date_view_pattern, date_list_pattern)
		values	(1, 'secofr', 'secofr', null, 'Security', 'Officer', 'secofr@thecompany.com', null, 'usr_active', 1,
			1, false, 'dd/MM/yyyy', 'dd/MM/yyyy', 'dd/MM/yyyy');
	insert into user(id, login_id, password, salutation_code, first_name, last_name, email_address, expiry_date, status_code, version,
			style_id, show_inspector, date_input_pattern, date_view_pattern, date_list_pattern)
		values	(2, 'admin', 'admin', null, 'The', 'Administrator', 'admin@thecompany.com', null, 'usr_active', 1,
			1, false, 'dd/MM/yyyy', 'dd/MM/yyyy', 'dd/MM/yyyy');
	insert into user(id, login_id, password, salutation_code, first_name, last_name, email_address, expiry_date, status_code, version,
			style_id, show_inspector, date_input_pattern, date_view_pattern, date_list_pattern)
		values	(3, 'john', 'john', 'usr_mr', 'John', 'Citizen', 'john@thecompany.com', '2010-12-31', 'usr_active', 1,
			1, false, 'dd/MM/yyyy', 'dd/MM/yyyy', 'dd/MM/yyyy');
		
	insert into role(id, name, status_code, version)
		values	(1, 'Security Officer', 'rol_active', 1);
	insert into role(id, name, status_code, version)
		values	(2, 'Administration', 'rol_active', 1);
	insert into role(id, name, status_code, version)
		values	(3, 'Accounts', 'rol_active', 1);

	insert into user_role(id, user_id, role_id, status_code, version)
		values	(1, 1, 1, 'uro_active', 1);
	insert into user_role(id, user_id, role_id, status_code, version)
		values	(2, 2, 2, 'uro_active', 1);
	insert into user_role(id, user_id, role_id, status_code, version)
		values	(3, 2, 3, 'uro_active', 1);
	insert into user_role(id, user_id, role_id, status_code, version)
		values	(4, 3, 3, 'uro_active', 1);

-- ------------------------------------------------------------------------------------------------------------