package jumpstart.max.business.commons.exception;

import java.io.Serializable;

import jumpstart.max.business.domain.base.BaseEntity;
import jumpstart.max.util.ClassUtil;
import jumpstart.max.util.MessageUtil;

@SuppressWarnings("serial")
public class AddWhatException extends BusinessException {
	private String _entityLabelMessageId;
	private Serializable _id;
	private String _fieldLabelMessageId;

	/**
	 * Throw this exception from an entity that has been asked to add a null object to a set of objects
	 * that it holds, typically in a composition relationship.
	 * For example, say class CodeGroup holds a set of Codes.  When asked to add a null Code  
	 * then it could <code>throw new AddWhatException(this, id, "Code")</code>.
	 *
	 * @param	entity	the entity holding the set of objects, eg. a CodeGroup object.
	 * @param	id		the id of the entity.
	 * @param	fieldLabelMessageId	the key of a message that represents the object being added, eg. "Code".
	 */
	public AddWhatException(BaseEntity entity, Serializable id, String fieldLabelMessageId) {

		// Don't convert the message ids to messages yet because we're in the server's locale, not the user's.

		super();
		_entityLabelMessageId = ClassUtil.extractUnqualifiedName(entity);
		_id = id;
		_fieldLabelMessageId = fieldLabelMessageId;
	}

	@Override
	public String getMessage() {

		// We deferred converting the message ids to messages until now, when we are more likely to be in the user's
		// locale.

		Object[] msgArgs = new Object[] { MessageUtil.toText(_entityLabelMessageId), _id,
				MessageUtil.toText(_fieldLabelMessageId) };

		String msg = MessageUtil.toText("AddWhatException", msgArgs);
		return msg;
	}

	public String getEntityLabelMessageId() {
		return _entityLabelMessageId;
	}

	public String getFieldLabelMessageId() {
		return _fieldLabelMessageId;
	}

	public Serializable getId() {
		return _id;
	}
}
