package jumpstart.max.business.commons.exception;

import jumpstart.max.business.domain.base.BaseEntity;
import jumpstart.max.util.ClassUtil;
import jumpstart.max.util.MessageUtil;

@SuppressWarnings("serial")
public class ReferencesWrongSubsetException extends BusinessException {
	private String _entityLabelMessageId;
	private String _fieldLabelMessageId;
	private String _referencedValueDescription;
	private String _referencedEntityLabelMessageId;
	private String _expectedSubsetDescription;
	private String _foundSubsetDescription;

	/**
	 * Throw this exception when an entity property, such as User.status, references another entity, such as a Code,
	 * that must belong to a particular subset, such as Code belonging to the "user statuses" CodeGroup (ie.
	 * code.codeGroup must point to the right CodeGroup).
	 * 
	 * @param entity
	 *            the entity, eg. a User object.
	 * @param fieldLabelMessageId
	 *            the key of a message that describes the entity and reference, eg. "User_status".
	 * @param referencedValueDescription
	 *            the value of the reference as a string, eg. "user_is_active".
	 * @param referencedEntityLabelMessageId
	 *            the key of a message that describes the entity controlling the subset , eg. "CodeGroup".
	 * @param expectedSubsetDescription
	 *            a description of the expected subset, eg. "usr_statuses", or CodeGroup.ID_USER_STATUS.toString().
	 * @param foundSubsetDescription
	 *            a description of the found subset, eg. "usr_salutations", or status.getCodeGroup().getId().toString().
	 */
	public ReferencesWrongSubsetException(BaseEntity entity, String fieldLabelMessageId,
			String referencedValueDescription, String referencedEntityLabelMessageId, String expectedSubsetDescription,
			String foundSubsetDescription) {

		// Don't convert the message ids to messages yet because we're in the server's locale, not the user's.

		super();
		_entityLabelMessageId = ClassUtil.extractUnqualifiedName(entity);
		_fieldLabelMessageId = fieldLabelMessageId;
		_referencedValueDescription = referencedValueDescription;
		_referencedEntityLabelMessageId = referencedEntityLabelMessageId;
		_expectedSubsetDescription = expectedSubsetDescription;
		_foundSubsetDescription = foundSubsetDescription;
	}

	@Override
	public String getMessage() {

		// We deferred converting the message ids to messages until now, when we are more likely to be in the user's
		// locale.

		Object[] msgArgs = new Object[] { MessageUtil.toText(_entityLabelMessageId),
				MessageUtil.toText(_fieldLabelMessageId), _referencedValueDescription,
				MessageUtil.toText(_referencedEntityLabelMessageId), _expectedSubsetDescription,
				_foundSubsetDescription };

		String msg = MessageUtil.toText("ReferencesWrongSubsetException", msgArgs);
		return msg;
	}

	public String getEntityLabelMessageId() {
		return _entityLabelMessageId;
	}

	public String getExpectedSubsetDescription() {
		return _expectedSubsetDescription;
	}

	public String getFieldLabelMessageId() {
		return _fieldLabelMessageId;
	}

	public String getFoundSubsetDescription() {
		return _foundSubsetDescription;
	}

	public String getReferencedEntityLabelMessageId() {
		return _referencedEntityLabelMessageId;
	}

	public String getReferencedValueDescription() {
		return _referencedValueDescription;
	}
}
