package jumpstart.max.business.commons.interpreter;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.commons.exception.UnexpectedException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServicesExceptionInterpreter {
	static private final Log LOG = LogFactory.getLog(ServicesExceptionInterpreter.class);

	private IEJBExceptionInterpreter _ejbExceptionInterpreter = new JBossExceptionInterpreter();

	public BusinessException interpretAsBusinessException(Throwable t) {
		try {
			BusinessException be = null;

			if (t instanceof BusinessException) {
				be = (BusinessException) t;
			}
			else if (t instanceof javax.persistence.OptimisticLockException) {
				be = _ejbExceptionInterpreter
						.interpretOptimisticLockException((javax.persistence.OptimisticLockException) t);
			}
			else if (t instanceof javax.persistence.EntityExistsException) {
				be = _ejbExceptionInterpreter
						.interpretEntityExistsException((javax.persistence.EntityExistsException) t);
			}
			else if (t instanceof javax.persistence.PersistenceException) {
				be = _ejbExceptionInterpreter
						.interpretOtherPersistenceException((javax.persistence.PersistenceException) t);
			}
			else if (t.getCause() != null && !t.getCause().equals(t)) {
				be = interpretAsBusinessException(t.getCause());
			}
			else {
				throw new UnexpectedException(t);
			}

			return be;
		}
		catch (UnexpectedException e) {
			LOG.error("Unexpected exception.  Root cause follows...");
			LOG.error(e.getRootCause());
			throw e;
		}
	}

}
