package jumpstart.max.business.domain.base;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.hibernate.LazyInitializationException;

public abstract class BaseEntity implements Serializable {

	static public final String INTERNAL_ID_PROP = "internalId";
	
	public abstract Serializable getIdForMessages();
	
	public String toStringLazy(Object obj, String getterName) {
		if (obj == null) {
			return "null";
		}

		try {
			Class c = obj.getClass();
			Method getterMethod = c.getMethod(getterName, (Class[]) null);
			Object result = getterMethod.invoke(obj, (Object[]) null);
			if (result == null) {
				return "<null>";
			}
			return result.toString();
		}
		catch (InvocationTargetException e) {
			Throwable t = e.getTargetException();
			if (t instanceof LazyInitializationException) {
				return "<lazy>";
			}
			else {
				throw new IllegalStateException("Exception in method lazy(..) with obj=" + obj + ", getterName=" + getterName
						+ ".", e);
			}
		}
		catch (Exception e) {
			throw new IllegalStateException("Exception in method lazy(..) with obj=" + obj + ", getterName=" + getterName + ".",
					e);
		}
	}

}
