package jumpstart.max.business.domain.examples;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

/**
 * The DateStuff entity.
 */
@Entity
@SuppressWarnings("serial")
public class DateStuff {

	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Column(name = "id", nullable = false)
	protected Long id;

	@Version
	@Column(name = "version", nullable = false)
	protected Integer version;

	@Temporal(TemporalType.TIMESTAMP)
	protected Date aTimestamp;

	@Temporal(TemporalType.DATE)
	protected Date aDate;

	@Temporal(TemporalType.TIME)
	protected Date aTime;

	protected java.sql.Timestamp aDateTime;

	protected java.sql.Date aDateMidnight;

	@Temporal(TemporalType.TIMESTAMP)
	protected Date aLocalDateTime;

	protected java.sql.Date aLocalDate;

	protected java.sql.Time aLocalTime;

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("DateStuff: [");
		buf.append("id=" + id + ", ");
		buf.append("aTimestamp=" + aTimestamp + ", ");
		buf.append("aDate=" + aDate + ", ");
		buf.append("aTime=" + aTime + ", ");
		buf.append("aDateTime=" + aDateTime + ", ");
		buf.append("aDateMidnight=" + aDateMidnight + ", ");
		buf.append("aLocalDateTime=" + aLocalDateTime + ", ");
		buf.append("aLocalDate=" + aLocalDate + ", ");
		buf.append("aLocalTime=" + aLocalTime + ", ");
		buf.append("version=" + version);
		buf.append("]");
		return buf.toString();
	}

	// The need for an equals() method is discussed at http://www.hibernate.org/109.html

	@Override
	public boolean equals(Object obj) {
		return (obj == this) || (obj instanceof DateStuff) && getId() != null && obj != null ? ((DateStuff) obj)
				.getId().equals(this.getId()) : super.equals(obj);
	}

	// The need for a hashCode() method is discussed at http://www.hibernate.org/109.html

	@Override
	public int hashCode() {
		return getId() == null ? super.hashCode() : getId().hashCode();
	}

	public Long getId() {
		return id;
	}

	public Integer getVersion() {
		return version;
	}

	public Date getADate() {
		return aDate;
	}

	public void setADate(Date aDate) {
		this.aDate = aDate;
	}

	public Date getATime() {
		return aTime;
	}

	public void setATime(Date aTime) {
		this.aTime = aTime;
	}

	public Date getATimestamp() {
		return aTimestamp;
	}

	public void setATimestamp(Date aTimestamp) {
		this.aTimestamp = aTimestamp;
	}

	public DateTime getADateTime() {
		// TODO - confirm this conversion always works, esp. across timezones
		return (aDateTime == null ? null : new DateTime(aDateTime));
	}

	public void setDateTime(DateTime dt) {
		// TODO - confirm this conversion always works, esp. across timezones
		this.aDateTime = (dt == null ? null : new java.sql.Timestamp(dt.getMillis()));
	}

	public DateMidnight getADateMidnight() {
		// TODO - confirm this conversion always works, esp. across timezones
		return (aDateMidnight == null ? null : new DateMidnight(aDateMidnight));
	}

	public void setDateMidnight(DateMidnight dm) {
		// TODO - confirm this conversion always works, esp. across timezones
		this.aDateMidnight = (dm == null ? null : new java.sql.Date(dm.getMillis()));
	}

	public LocalDateTime getALocalDateTime() {
		// TODO - confirm this conversion always works, esp. across timezones
		return (aLocalDateTime == null ? null : new LocalDateTime(aLocalDateTime));
	}

	public void setLocalDateTime(LocalDateTime ldt) {
		// TODO - confirm this conversion always works, esp. across timezones
		this.aLocalDateTime = (ldt == null ? null : new java.sql.Timestamp(ldt.toDateTime().getMillis()));
	}

	public LocalDate getALocalDate() {
		// TODO - confirm this conversion always works, esp. across timezones
		return (aLocalDate == null ? null : new LocalDate(aLocalDate));
	}

	public void setLocalDate(LocalDate ld) {
		// TODO - confirm this conversion always works, esp. across timezones
		this.aLocalDate = (ld == null ? null : new java.sql.Date(ld.toDateMidnight().getMillis()));
	}

	public LocalTime getALocalTime() {
		// TODO - confirm this conversion always works, esp. across timezones
		return (aLocalTime == null ? null : new LocalTime(aLocalTime));
	}

	public void setLocalTime(LocalTime lt) {
		// TODO - confirm this conversion always works, esp. across timezones
		this.aLocalTime = (lt == null ? null : new java.sql.Time(lt.toDateTimeToday().getMillis()));
	}

}
