package jumpstart.max.business.domain.examples;

import java.util.List;

import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import jumpstart.max.business.domain.examples.iface.IExamplesServiceLocal;
import jumpstart.max.business.domain.examples.iface.IExamplesServiceRemote;

@Stateless
@Local(IExamplesServiceLocal.class)
@Remote(IExamplesServiceRemote.class)
public class ExamplesService implements IExamplesServiceLocal, IExamplesServiceRemote {

	@PersistenceContext(unitName = "jumpstart-max")
	protected EntityManager _em;
	
	// Person

	public Person findPerson(Long id) {
		Person obj = _em.find(Person.class, id);
		return obj;
	}

	@SuppressWarnings("unchecked")
	public List<Person> findPersons() {

		StringBuffer buf = new StringBuffer();
		buf.append("select p from Person p");
		buf.append(" order by p.id");

		Query q = _em.createQuery(buf.toString());
		List l = q.getResultList();

		return l;
	}

	public void changePerson(Person person) {
		person = _em.merge(person);
	}
	
	// DateStuff

	public DateStuff findDateStuff(Long id) {
		DateStuff obj = _em.find(DateStuff.class, id);
		return obj;
	}

	public void changeDateStuff(DateStuff dateStuff) {
		dateStuff = _em.merge(dateStuff);
	}

}
