package jumpstart.max.business.domain.examples;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Version;

/**
 * The Person entity.
 */
@Entity
@SuppressWarnings("serial")
public class Person {

	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Column(name = "id", nullable = false)
	protected Long id;

	@Version
	protected Integer version;

	@Column(length = 10, nullable = false)
	protected String firstName;

	@Column(length = 10, nullable = false)
	protected String lastName;

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("Person: [");
		buf.append("id=" + id + ", ");
		buf.append("firstName=" + firstName + ", ");
		buf.append("lastName=" + lastName + ", ");
		buf.append("version=" + version);
		buf.append("]");
		return buf.toString();
	}

	// The need for an equals() method is discussed at http://www.hibernate.org/109.html

	@Override
	public boolean equals(Object obj) {
		return (obj == this) || (obj instanceof Person) && getId() != null && obj != null ? ((Person) obj).getId()
				.equals(this.getId()) : super.equals(obj);
	}

	// The need for a hashCode() method is discussed at http://www.hibernate.org/109.html

	@Override
	public int hashCode() {
		return getId() == null ? super.hashCode() : getId().hashCode();
	}

	@PrePersist
	@PreUpdate
	public void validate() throws ValidationException {

		// Validate syntax...

		if ((firstName == null) || (firstName.trim().length() == 0)) {
			throw new ValidationException("First name is required.");
		}

		if ((lastName == null) || (lastName.trim().length() == 0)) {
			throw new ValidationException("Last name is required.");
		}

	}

	public Long getId() {
		return id;
	}

	public Integer getVersion() {
		return version;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

}
