package jumpstart.max.business.domain.reference;

import java.util.List;

import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;

import jumpstart.max.business.commons.exception.DoesNotExistException;
import jumpstart.max.business.commons.query.QueryBuilder;
import jumpstart.max.business.commons.query.SearchOptions;
import jumpstart.max.business.domain.base.BaseSvc;
import jumpstart.max.business.domain.reference.iface.CodeGroupSearchFields;
import jumpstart.max.business.domain.reference.iface.CodeSearchFields;
import jumpstart.max.business.domain.reference.iface.IReferenceFinderSvcLocal;
import jumpstart.max.business.domain.reference.iface.IReferenceFinderSvcRemote;

/**
 * @author geocal To change this generated comment go to Window>Preferences>Java>Code Generation>Code and Comments
 */
// @SecurityDomain("jumpstart")
@Stateless
@Local(IReferenceFinderSvcLocal.class)
@Remote(IReferenceFinderSvcRemote.class)
public class ReferenceFinderSvc extends BaseSvc implements IReferenceFinderSvcLocal, IReferenceFinderSvcRemote {

	public Code findCode(String id) throws DoesNotExistException {
		Code obj = (Code) find(Code.class, id);
		return obj;
	}

	public Code findCodeShallowish(String id) throws DoesNotExistException {

		try {
			StringBuffer buf = new StringBuffer();
			buf.append("select c from Code c");
			buf.append(" left join fetch c.codeGroup");
			buf.append(" join fetch c.status");
			buf.append(" where c.id = :id");

			Query q = _em.createQuery(buf.toString());
			q.setParameter("id", id);

			Code obj = (Code) q.getSingleResult();
			return obj;
		}
		catch (NoResultException e) {
			throw new DoesNotExistException(Code.class, id);
		}
		catch (NonUniqueResultException e) {
			throw new IllegalStateException("Duplicate Code found with id = " + id + ".");
		}
	}

	@SuppressWarnings("unchecked")
	public List<Code> findCodesShallowish() {

		StringBuffer buf = new StringBuffer();
		buf.append("select c from Code c");
		buf.append(" left join fetch c.codeGroup");
		buf.append(" join fetch c.status");
		buf.append(" order by c.description");

		Query q = _em.createQuery(buf.toString());
		List l = q.getResultList();

		return l;
	}

	@SuppressWarnings("unchecked")
	public List<Code> findCodesShallowish(CodeSearchFields search, SearchOptions options) {

		QueryBuilder builder = new QueryBuilder("");
		builder.append("select c from Code c");
		builder.append(" left join fetch c.codeGroup");
		builder.append(" join fetch c.status");
		builder.appendLikeIgnoreCase("c.id", search.getId());
		builder.appendEquals("c.codeGroup.id", search.getCodeGroupId(), true);
		builder.appendEquals("c.status.id", search.getStatusId(), true);
		builder.appendLikeIgnoreCase("c.description", search.getDescription());
		builder.appendLikeIgnoreCase("c.shortDescription", search.getShortDescription());
		builder.appendEquals("c.displaySeq", search.getDisplaySeq(), true);
		builder.appendEquals("c.version", search.getVersion(), true);

		if (options.getSortColumnNames().size() == 0) {
			builder.append(" order by c.description");
		}

		Query q = builder.createQuery(_em, options, "c");

		List l = q.getResultList();

		return l;
	}

	@SuppressWarnings("unchecked")
	public List<Code> findCodesShallowishByCodeGroup(String codeGroupId) {

		StringBuffer buf = new StringBuffer();
		buf.append("select c from Code c");
		buf.append(" left join fetch c.codeGroup");
		buf.append(" join fetch c.status");
		buf.append(" where c.codeGroup.id = :codeGroupId");
		buf.append(" order by c.description");

		Query q = _em.createQuery(buf.toString());
		q.setParameter("codeGroupId", codeGroupId);

		List l = q.getResultList();

		return l;
	}

	public CodeGroup findCodeGroup(String id) throws DoesNotExistException {
		CodeGroup obj = (CodeGroup) find(CodeGroup.class, id);
		return obj;
	}

	public CodeGroup findCodeGroupShallowish(String id) throws DoesNotExistException {

		StringBuffer buf = new StringBuffer();
		buf.append("select c from CodeGroup c");
		buf.append(" join fetch c.status");
		buf.append(" where c.id = :id");

		Query q = _em.createQuery(buf.toString());
		q.setParameter("id", id);

		try {
			CodeGroup obj = (CodeGroup) q.getSingleResult();
			return obj;
		}
		catch (NoResultException e) {
			throw new DoesNotExistException(CodeGroup.class, id);
		}
		catch (NonUniqueResultException e) {
			throw new IllegalStateException("Duplicate CodeGroup found with id = " + id + ".");
		}
	}

	@SuppressWarnings("unchecked")
	public List<CodeGroup> findCodeGroupsShallowish() {

		StringBuffer buf = new StringBuffer();
		buf.append("select c from CodeGroup c");
		buf.append(" join fetch c.status");
		buf.append(" order by c.description");

		Query q = _em.createQuery(buf.toString());

		List l = q.getResultList();

		return l;
	}

	@SuppressWarnings("unchecked")
	public List<CodeGroup> findCodeGroupsShallowish(CodeGroupSearchFields search, SearchOptions options) {

		QueryBuilder builder = new QueryBuilder("");
		builder.append("select c from CodeGroup c");
		builder.append(" join fetch c.status");
		builder.appendLikeIgnoreCase("c.id", search.getId());
		builder.appendEquals("c.status.id", search.getStatusId(), true);
		builder.appendLikeIgnoreCase("c.description", search.getDescription());
		builder.appendLikeIgnoreCase("c.shortDescription", search.getShortDescription());
		builder.appendEquals("c.version", search.getVersion(), true);

		if (options.getSortColumnNames().size() == 0) {
			builder.append(" order by c.description");
		}

		Query q = builder.createQuery(_em, options, "c");

		List l = q.getResultList();

		return l;
	}

}
