package jumpstart.max.business.domain.reference;

import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.domain.base.BaseSvc;
import jumpstart.max.business.domain.reference.iface.IReferenceManagerSvcLocal;
import jumpstart.max.business.domain.reference.iface.IReferenceManagerSvcRemote;

//@SecurityDomain("jumpstart")
@Stateless
@Local(IReferenceManagerSvcLocal.class)
@Remote(IReferenceManagerSvcRemote.class)
public class ReferenceManagerSvc extends BaseSvc implements IReferenceManagerSvcLocal, IReferenceManagerSvcRemote {

	/*******************************************************************************************************************
	 * BUSINESS METHODS
	 ******************************************************************************************************************/

	/*******************************************************************************************************************
	 * PERSISTENCE METHODS
	 ******************************************************************************************************************/

	/**
	 * Use this "add" method when you don't care whether the parent(s) have changed while you've been preparing this
	 * child.
	 */
	public Code addCode(Code code, String codeGroupId) throws BusinessException {

		// Get the parent(s) and add it to them

		CodeGroup codeGroup = null;
		if (codeGroupId != null) {
			codeGroup = (CodeGroup) find(CodeGroup.class, codeGroupId);
		}
		return this.addCode(code, codeGroup);
	}

	/**
	 * Use this "add" method when you want to ensure the parent(s) haven't changed while you've been preparing this
	 * child.
	 */
	public Code addCode(Code code, CodeGroup codeGroup) throws BusinessException {

		if (codeGroup != null) {
			codeGroup = (CodeGroup) merge(codeGroup);
			codeGroup.addCode(code);
		}

		code.setCodeGroup(codeGroup);
		persist(code);
		return code;
	}

	public void changeCode(Code code) throws BusinessException {
		merge(code);
	}

	public void removeCode(Code code) throws BusinessException {
		code = (Code) merge(code);

		CodeGroup codeGroup = code.getCodeGroup();
		if (codeGroup != null) {
			codeGroup.removeCode(code);
		}

		remove(code);
	}

	public CodeGroup createCodeGroup(CodeGroup codeGroup) throws BusinessException {
		persist(codeGroup);
		return codeGroup;
	}

	public void changeCodeGroup(CodeGroup codeGroup) throws BusinessException {
		merge(codeGroup);
	}

	public void deleteCodeGroup(CodeGroup codeGroup) throws BusinessException {
		codeGroup = (CodeGroup) merge(codeGroup);
		remove(codeGroup);
	}

}
