package jumpstart.max.business.domain.reference.iface;

import java.util.List;

import jumpstart.max.business.commons.exception.DoesNotExistException;
import jumpstart.max.business.commons.query.SearchOptions;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.CodeGroup;

/**
 * The <code>IReferenceFinderSvcRemote</code> bean exposes the business methods in the interface.
 * 
 * @author Geoff Callender JumpStart
 * @version $Revision: 1.29 $, $Date: 2005/08/21 13:04:12 $
 */
public interface IReferenceFinderSvcRemote {

	// Code

	Code findCode(String id) throws DoesNotExistException;

	Code findCodeShallowish(String id) throws DoesNotExistException;

	List<Code> findCodesShallowish();

	List<Code> findCodesShallowish(CodeSearchFields searchFields, SearchOptions searchOptions);

	List<Code> findCodesShallowishByCodeGroup(String codeGroupId);

	// CodeGroup

	CodeGroup findCodeGroup(String id) throws DoesNotExistException;

	CodeGroup findCodeGroupShallowish(String id) throws DoesNotExistException;

	List<CodeGroup> findCodeGroupsShallowish();

	List<CodeGroup> findCodeGroupsShallowish(CodeGroupSearchFields searchFields, SearchOptions searchOptions);
}
