package jumpstart.max.business.domain.reference.iface;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.CodeGroup;

/**
 * The <code>IReferenceManagerSvcRemote</code> bean exposes the business methods in the interface.
 * 
 * @author Geoff Callender JumpStart
 * @version $Revision: 1.29 $, $Date: 2005/08/21 13:04:12 $
 */
public interface IReferenceManagerSvcRemote {

	/*******************************************************************************************************************
	 * BUSINESS METHODS
	 ******************************************************************************************************************/

	/*******************************************************************************************************************
	 * PERSISTENCE METHODS
	 ******************************************************************************************************************/

	// Code
	/**
	 * Use this "add" method when you don't care whether the parent(s) have changed while you've been preparing this
	 * child.
	 */
	Code addCode(Code code, String codeGroupId) throws BusinessException;

	/**
	 * Use this "add" method when you want to ensure the parent(s) haven't changed while you've been preparing this
	 * child.
	 */
	Code addCode(Code code, CodeGroup codeGroup) throws BusinessException;

	void changeCode(Code code) throws BusinessException;

	void removeCode(Code code) throws BusinessException;

	// CodeGroup

	CodeGroup createCodeGroup(CodeGroup codeGroup) throws BusinessException;

	void changeCodeGroup(CodeGroup codeGroup) throws BusinessException;

	void deleteCodeGroup(CodeGroup codeGroup) throws BusinessException;
}
