package jumpstart.max.business.domain.security;

import java.util.List;

import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;

import jumpstart.max.business.commons.exception.AuthenticationException;
import jumpstart.max.business.commons.exception.DoesNotExistException;
import jumpstart.max.business.commons.query.ComparisonOperator;
import jumpstart.max.business.commons.query.QueryBuilder;
import jumpstart.max.business.commons.query.SearchOptions;
import jumpstart.max.business.domain.base.BaseSvc;
import jumpstart.max.business.domain.security.iface.ISecurityFinderSvcLocal;
import jumpstart.max.business.domain.security.iface.ISecurityFinderSvcRemote;
import jumpstart.max.business.domain.security.iface.RoleSearchFields;
import jumpstart.max.business.domain.security.iface.UserRoleSearchFields;
import jumpstart.max.business.domain.security.iface.UserSearchFields;

/**
 * @author geocal To change this generated comment go to Window>Preferences>Java>Code Generation>Code and Comments
 */
// @SecurityDomain("jumpstart")
@Stateless
@Local(ISecurityFinderSvcLocal.class)
@Remote(ISecurityFinderSvcRemote.class)
public class SecurityFinderSvc extends BaseSvc implements ISecurityFinderSvcLocal, ISecurityFinderSvcRemote {

	public Role findRole(Long id) throws DoesNotExistException {
		Role obj = (Role) find(Role.class, id);
		return obj;
	}

	public Role findRoleShallowish(Long id) throws DoesNotExistException {

		try {
			StringBuffer buf = new StringBuffer();
			buf.append("select r from Role r");
			buf.append(" join fetch r.status");
			buf.append(" where r.id = :id");

			Query q = _em.createQuery(buf.toString());
			q.setParameter("id", id);

			Role obj = (Role) q.getSingleResult();
			return obj;
		}
		catch (NoResultException e) {
			throw new DoesNotExistException(Role.class, id);
		}
		catch (NonUniqueResultException e) {
			throw new IllegalStateException("Duplicate Role found with id = " + id + ".");
		}
	}

	@SuppressWarnings("unchecked")
	public List<Role> findRolesShallowish() {

		StringBuffer buf = new StringBuffer();
		buf.append("select r from Role r");
		buf.append(" join fetch r.status");
		buf.append(" order by r.name");

		Query q = _em.createQuery(buf.toString());

		List l = q.getResultList();

		return l;
	}

	@SuppressWarnings("unchecked")
	public List<Role> findRolesShallowish(RoleSearchFields search, SearchOptions options) {

		QueryBuilder builder = new QueryBuilder("");
		builder.append("select r from Role r");
		builder.append(" join fetch r.status");
		builder.appendEquals("r.status.id", search.getStatusId(), true);
		builder.appendLikeIgnoreCase("r.name", search.getName());
		builder.appendEquals("r.version", search.getVersion(), true);

		if (options.getSortColumnNames().size() == 0) {
			builder.append(" order by r.name");
		}

		Query q = builder.createQuery(_em, options, "r");

		List l = q.getResultList();

		return l;
	}

	public User findUser(Long id) throws DoesNotExistException {
		User obj = (User) find(User.class, id);
		return obj;
	}

	public User findUserShallowish(Long id) throws DoesNotExistException {

		try {
			StringBuffer buf = new StringBuffer();
			buf.append("select u from User u");
			buf.append(" join fetch u.status");
			buf.append(" left join fetch u.salutation");
			buf.append(" where u.id = :id");

			Query q = _em.createQuery(buf.toString());
			q.setParameter("id", id);

			User obj = (User) q.getSingleResult();
			return obj;
		}
		catch (NoResultException e) {
			throw new DoesNotExistException(User.class, id);
		}
		catch (NonUniqueResultException e) {
			throw new IllegalStateException("Duplicate User found with id = " + id + ".");
		}
	}

	public User authenticateUser(String loginId, String password) throws AuthenticationException {
		User user;
		try {
			user = findUserShallowishByLoginId(loginId);
		}
		catch (DoesNotExistException e) {
			throw new AuthenticationException("User_loginId_unknown", loginId);
		}
		user.authenticate(password);
		return user;
	}

	public User findUserShallowishByLoginId(String loginId) throws DoesNotExistException {

		try {
			StringBuffer buf = new StringBuffer();
			buf.append("select u from User u");
			buf.append(" join fetch u.status");
			buf.append(" left join fetch u.salutation");
			buf.append(" where u.loginId = :loginId");

			Query q = _em.createQuery(buf.toString());
			q.setParameter("loginId", loginId);

			User obj = (User) q.getSingleResult();
			return obj;
		}
		catch (NoResultException e) {
			throw new DoesNotExistException(User.class, loginId);
		}
		catch (NonUniqueResultException e) {
			throw new IllegalStateException("Duplicate User found with loginId = " + loginId + ".");
		}
	}

	public User findUserAndRoles(String loginId) throws DoesNotExistException {

		try {
			StringBuffer buf = new StringBuffer();
			buf.append("select u from User u");
			buf.append(" join fetch u.status");
			buf.append(" left join fetch u.salutation");
			buf.append(" left join fetch u.userRoles");
			buf.append(" where u.loginId = :loginId");

			Query q = _em.createQuery(buf.toString());
			q.setParameter("loginId", loginId);

			User obj = (User) q.getSingleResult();
			return obj;
		}
		catch (NoResultException e) {
			throw new DoesNotExistException(User.class, loginId);
		}
		catch (NonUniqueResultException e) {
			throw new IllegalStateException("Duplicate User found with loginId = " + loginId + ".");
		}
	}

	@SuppressWarnings("unchecked")
	public List<User> findUsersShallowish() {

		StringBuffer buf = new StringBuffer();
		buf.append("select u from User u");
		buf.append(" join fetch u.status");
		buf.append(" left join fetch u.salutation");
		buf.append(" order by u.loginId");

		Query q = _em.createQuery(buf.toString());
		List l = q.getResultList();

		return l;
	}

	@SuppressWarnings("unchecked")
	public List<User> findUsersShallowish(UserSearchFields search, SearchOptions options) {

		QueryBuilder builder = new QueryBuilder("");
		builder.append("select u from User u");
		builder.append(" join fetch u.status");
		builder.append(" left join fetch u.salutation");
		builder.appendEquals("u.status.id", search.getStatusId(), true);
		builder.appendLikeIgnoreCase("u.loginId", search.getLoginId());
		builder.appendLikeIgnoreCase("u.password", search.getPassword());
		builder.appendEquals("u.salutation.id", search.getSalutationId(), true);
		builder.appendLikeIgnoreCase("u.firstName", search.getFirstName());
		builder.appendLikeIgnoreCase("u.lastName", search.getLastName());
		builder.appendLikeIgnoreCase("u.emailAddress", search.getEmailAddress());
		builder.appendComparison("u.expiryDate", ComparisonOperator.EQ, search.getExpiryDate());
		builder.appendEquals("u.version", search.getVersion(), true);

		if (options.getSortColumnNames().size() == 0) {
			builder.append(" order by u.loginId");
		}

		Query q = builder.createQuery(_em, options, "u");

		List l = q.getResultList();

		return l;
	}

	public UserRole findUserRole(Long id) throws DoesNotExistException {
		UserRole obj = (UserRole) find(UserRole.class, id);
		return obj;
	}

	public UserRole findUserRoleShallowish(Long id) throws DoesNotExistException {

		StringBuffer buf = new StringBuffer();
		buf.append("select u from UserRole u");
		buf.append(" join fetch u.status");
		buf.append(" join fetch u.user");
		buf.append(" join fetch u.role");
		buf.append(" where u.id = :id");

		Query q = _em.createQuery(buf.toString());
		q.setParameter("id", id);

		try {
			UserRole obj = (UserRole) q.getSingleResult();
			return obj;
		}
		catch (NoResultException e) {
			throw new DoesNotExistException(UserRole.class, id);
		}
		catch (NonUniqueResultException e) {
			throw new IllegalStateException("Duplicate UserRole found with id = " + id + ".");
		}
	}

	@SuppressWarnings("unchecked")
	public List<UserRole> findUserRolesShallowish() {

		StringBuffer buf = new StringBuffer();
		buf.append("select u from UserRole u");
		buf.append(" join fetch u.status");
		buf.append(" join fetch u.user");
		buf.append(" join fetch u.role");
		buf.append(" order by u.id");

		Query q = _em.createQuery(buf.toString());

		List l = q.getResultList();

		return l;
	}

	@SuppressWarnings("unchecked")
	public List<UserRole> findUserRolesShallowish(UserRoleSearchFields search, SearchOptions options) {

		QueryBuilder builder = new QueryBuilder("");
		builder.append("select u from UserRole u");
		builder.append(" join fetch u.status");
		builder.append(" join fetch u.user");
		builder.append(" join fetch u.role");
		builder.appendEquals("u.status.id", search.getStatusId(), true);
		builder.appendEquals("u.user.id", search.getUserId(), true);
		builder.appendEquals("u.role.id", search.getRoleId(), true);
		builder.appendEquals("u.version", search.getVersion(), true);

		if (options.getSortColumnNames().size() == 0) {
			builder.append(" order by u.id");
		}

		Query q = builder.createQuery(_em, options, "u");

		List l = q.getResultList();

		return l;
	}

	@SuppressWarnings("unchecked")
	public List<UserRole> findUserRolesShallowishByUser(Long userId) {

		StringBuffer buf = new StringBuffer();
		buf.append("select u from UserRole u");
		buf.append(" join fetch u.status");
		buf.append(" join fetch u.user");
		buf.append(" join fetch u.role");
		buf.append(" where u.user.id = :userId");
		buf.append(" order by u.id");

		Query q = _em.createQuery(buf.toString());
		q.setParameter("userId", userId);

		List l = q.getResultList();

		return l;
	}

	@SuppressWarnings("unchecked")
	public List<UserRole> findUserRolesShallowishByRole(Long roleId) {

		StringBuffer buf = new StringBuffer();
		buf.append("select u from UserRole u");
		buf.append(" join fetch u.status");
		buf.append(" join fetch u.user");
		buf.append(" join fetch u.role");
		buf.append(" where u.role.id = :roleId");
		buf.append(" order by u.id");

		Query q = _em.createQuery(buf.toString());
		q.setParameter("roleId", roleId);

		List l = q.getResultList();

		return l;
	}

}
