package jumpstart.max.business.domain.security;

import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.domain.base.BaseSvc;
import jumpstart.max.business.domain.security.iface.ISecurityManagerSvcLocal;
import jumpstart.max.business.domain.security.iface.ISecurityManagerSvcRemote;

//@SecurityDomain("jumpstart")
@Stateless
@Local(ISecurityManagerSvcLocal.class)
@Remote(ISecurityManagerSvcRemote.class)
public class SecurityManagerSvc extends BaseSvc implements ISecurityManagerSvcLocal, ISecurityManagerSvcRemote {

	/*******************************************************************************************************************
	 * BUSINESS METHODS
	 ******************************************************************************************************************/

	/**
	 * This method provides a way for users to change their own password.
	 */
	public void changeUserPassword(Long id, String currentPassword, String newPassword) throws BusinessException {
		User user = (User) find(User.class, id);
		user.changePassword(currentPassword, newPassword);
	}

	/**
	 * This method provides a way for security officers to "reset" the password.
	 */
	public void changeUserPassword(Long id, String newPassword) throws BusinessException {
		User user = (User) find(User.class, id);
		user.setPassword(newPassword);
	}

	/*******************************************************************************************************************
	 * PERSISTENCE METHODS
	 ******************************************************************************************************************/

	public Role createRole(Role role) throws BusinessException {
		persist(role);
		return role;
	}

	public void changeRole(Role role) throws BusinessException {
		merge(role);
	}

	public void deleteRole(Role role) throws BusinessException {
		role = (Role) merge(role);
		remove(role);
	}

	public User createUser(User user, String password) throws BusinessException {
		user.changePassword(null, password);
		persist(user);
		return user;
	}

	public void changeUser(User user) throws BusinessException {
		merge(user);
	}

	public void deleteUser(User user) throws BusinessException {
		user = (User) merge(user);
		remove(user);
	}

	/**
	 * Use this "add" method when you don't care whether the parent(s) have changed while you've been preparing this
	 * child.
	 */
	public UserRole addUserRole(UserRole userRole, Long userId, Long roleId) throws BusinessException {

		// Get the parent(s) and add it to them

		User user = (User) find(User.class, userId);
		Role role = (Role) find(Role.class, roleId);
		return this.addUserRole(userRole, user, role);
	}

	/**
	 * Use this "add" method when you want to ensure the parent(s) haven't changed while you've been preparing this
	 * child.
	 */
	public UserRole addUserRole(UserRole userRole, User user, Role role) throws BusinessException {
		user = (User) merge(user);
		user.addUserRole(userRole);

		role = (Role) merge(role);
		role.addUserRole(userRole);

		userRole.setUser(user);
		userRole.setRole(role);
		persist(userRole);

		return userRole;
	}

	public void changeUserRole(UserRole userRole) throws BusinessException {
		merge(userRole);
	}

	public void removeUserRole(UserRole userRole) throws BusinessException {
		userRole = (UserRole) merge(userRole);

		User user = userRole.getUser();
		user.removeUserRole(userRole);

		Role role = userRole.getRole();
		role.removeUserRole(userRole);

		remove(userRole);
	}

}
