package jumpstart.max.business.domain.security.iface;

import java.util.List;

import jumpstart.max.business.commons.exception.AuthenticationException;
import jumpstart.max.business.commons.exception.DoesNotExistException;
import jumpstart.max.business.commons.query.SearchOptions;
import jumpstart.max.business.domain.security.Role;
import jumpstart.max.business.domain.security.User;
import jumpstart.max.business.domain.security.UserRole;

/**
 * The <code>ISecurityFinderSvcRemote</code> bean exposes the business methods in the interface.
 * 
 * @author Geoff Callender JumpStart
 * @version $Revision: 1.29 $, $Date: 2005/08/21 13:04:12 $
 */
public interface ISecurityFinderSvcRemote {

	// Role

	Role findRole(Long id) throws DoesNotExistException;

	Role findRoleShallowish(Long id) throws DoesNotExistException;

	List<Role> findRolesShallowish();

	List<Role> findRolesShallowish(RoleSearchFields searchFields, SearchOptions searchOptions);

	// User

	User findUser(Long id) throws DoesNotExistException;

	User findUserShallowish(Long id) throws DoesNotExistException;

	List<User> findUsersShallowish();

	List<User> findUsersShallowish(UserSearchFields searchFields, SearchOptions searchOptions);

	User authenticateUser(String loginId, String password) throws AuthenticationException;

	// UserRole

	UserRole findUserRole(Long id) throws DoesNotExistException;

	UserRole findUserRoleShallowish(Long id) throws DoesNotExistException;

	List<UserRole> findUserRolesShallowish();

	List<UserRole> findUserRolesShallowish(UserRoleSearchFields searchFields, SearchOptions searchOptions);

	List<UserRole> findUserRolesShallowishByUser(Long userId);

	List<UserRole> findUserRolesShallowishByRole(Long roleId);
}
