package jumpstart.max.business.domain.security.iface;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.domain.security.Role;
import jumpstart.max.business.domain.security.User;
import jumpstart.max.business.domain.security.UserRole;

/**
 * The <code>ISecurityManagerSvcRemote</code> bean exposes the business methods in the interface.
 * 
 * @author Geoff Callender JumpStart
 * @version $Revision: 1.29 $, $Date: 2005/08/21 13:04:12 $
 */
public interface ISecurityManagerSvcRemote {

	/*******************************************************************************************************************
	 * BUSINESS METHODS
	 ******************************************************************************************************************/

	/**
	 * This method provides a way for users to change their own password.
	 */
	void changeUserPassword(Long id, String currentPassword, String newPassword) throws BusinessException;

	/**
	 * This method provides a way for security officers to "reset" the password.
	 */
	void changeUserPassword(Long id, String newPassword) throws BusinessException;

	/*******************************************************************************************************************
	 * PERSISTENCE METHODS
	 ******************************************************************************************************************/

	// Role
	Role createRole(Role role) throws BusinessException;

	void changeRole(Role role) throws BusinessException;

	void deleteRole(Role role) throws BusinessException;

	// User

	User createUser(User user, String password) throws BusinessException;

	void changeUser(User user) throws BusinessException;

	void deleteUser(User user) throws BusinessException;

	// UserRole

	/**
	 * Use this "add" method when you don't care whether the parent(s) have changed while you've been preparing this
	 * child.
	 */
	UserRole addUserRole(UserRole userRole, Long userId, Long roleId) throws BusinessException;

	/**
	 * Use this "add" method when you want to ensure the parent(s) haven't changed while you've been preparing this
	 * child.
	 */
	UserRole addUserRole(UserRole userRole, User user, Role role) throws BusinessException;

	void changeUserRole(UserRole userRole) throws BusinessException;

	void removeUserRole(UserRole userRole) throws BusinessException;
}
