package jumpstart.max.util;

public class ExceptionFormatter {
	static public final String LINE_SEPARATOR = System.getProperty("line.separator");

	static public String toAString(Throwable throwable) {
		StringBuffer buf = new StringBuffer(throwable.toString());

		// Get and format the stack trace

		StackTraceElement[] elements = throwable.getStackTrace();
		for (int i = 0; i < elements.length; i++) {
			buf.append(LINE_SEPARATOR + "  [" + i + "] " + elements[i]);
		}
		buf.append(LINE_SEPARATOR);
		buf.append("}");

		// If there is a cause, get and format it

		if (throwable.getCause() != null) {
			buf.append(LINE_SEPARATOR + "...caused by..." + LINE_SEPARATOR);
			buf.append(ExceptionFormatter.toAString(throwable.getCause()));
		}

		// Return the lot as a string

		return buf.toString();
	}

}
