package jumpstart.max.business;

import java.io.IOException;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.commons.interpreter.ServicesExceptionInterpreter;
import jumpstart.max.business.domain.reference.iface.IReferenceFinderSvcRemote;
import jumpstart.max.business.domain.reference.iface.IReferenceManagerSvcRemote;
import jumpstart.max.business.domain.security.iface.ISecurityFinderSvcRemote;
import jumpstart.max.business.domain.security.iface.ISecurityManagerSvcRemote;
import jumpstart.max.util.ExceptionFormatter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdHocTester {
	static private final Log LOG = LogFactory.getLog(AdHocTester.class);

	@SuppressWarnings("unused")
	static private IReferenceFinderSvcRemote _referenceFinderSvc;
	@SuppressWarnings("unused")
	static private IReferenceManagerSvcRemote _referenceManagerSvc;
	@SuppressWarnings("unused")
	static private ISecurityFinderSvcRemote _securityFinderSvc;
	@SuppressWarnings("unused")
	static private ISecurityManagerSvcRemote _securityManagerSvc;

	static private ServicesExceptionInterpreter _servicesExceptionInterpreter = new ServicesExceptionInterpreter();

	static public void main(String[] args) {

		try {
			locateServices();
			AdHocTester tester = new AdHocTester();
			tester.run("admin", "admin");
		}
		catch (Exception e) {
			BusinessException s = _servicesExceptionInterpreter.interpretAsBusinessException(e);
			LOG.error(ExceptionFormatter.toAString(s));
		}
	}

	static public void locateServices() {
		InitialContext initialContext = null;

		try {
			initialContext = new InitialContext();
			System.out.println("InitialContext environment = " + initialContext.getEnvironment());
			_referenceFinderSvc = (IReferenceFinderSvcRemote) initialContext
					.lookup("jumpstart-max/ReferenceFinderSvc/remote");
			_referenceManagerSvc = (IReferenceManagerSvcRemote) initialContext
					.lookup("jumpstart-max/ReferenceManagerSvc/remote");
			_securityFinderSvc = (ISecurityFinderSvcRemote) initialContext
					.lookup("jumpstart-max/SecurityFinderSvc/remote");
			_securityManagerSvc = (ISecurityManagerSvcRemote) initialContext
					.lookup("jumpstart-max/SecurityManagerSvc/remote");
		}
		catch (NoInitialContextException e) {
			e.printStackTrace();
			throw new RuntimeException(
					"Could not locate services.  Is jndi.properties missing from the testing classpath?", e);
		}
		catch (NamingException e) {
			e.printStackTrace();
			throw new RuntimeException(
					"Could not locate services.  Is JBoss server started?  Is jbossall-client.jar missing from the testing classpath?",
					e);
		}

	}
	public void run(String adminUserName, String adminPassword) throws IOException {
		// Put tests here
	}
}
