package jumpstart.max.business;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;

import jumpstart.max.business.commons.interpreter.ServicesExceptionInterpreter;
import jumpstart.max.business.domain.reference.iface.IReferenceFinderSvcRemote;
import jumpstart.max.business.domain.reference.iface.IReferenceManagerSvcRemote;
import jumpstart.max.business.domain.security.iface.ISecurityFinderSvcRemote;
import jumpstart.max.business.domain.security.iface.ISecurityManagerSvcRemote;
import junit.framework.TestCase;

public class BaseTest extends TestCase {

	static private boolean _servicesLocated = false;

	static protected IReferenceFinderSvcRemote _referenceFinderSvc;
	static protected IReferenceManagerSvcRemote _referenceManagerSvc;
	static protected ISecurityFinderSvcRemote _securityFinderSvc;
	static protected ISecurityManagerSvcRemote _securityManagerSvc;

	static protected ServicesExceptionInterpreter _interpreter = new ServicesExceptionInterpreter();

	public BaseTest(String arg0) {
		super(arg0);
	}

	/*
	 * @see TestCase#setUp()
	 */
	public void setUp() throws Exception {
		super.setUp();

		if (!_servicesLocated) {
			locateServices();
			_servicesLocated = true;
		}
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void locateServices() {
		InitialContext initialContext = null;

		try {
			initialContext = new InitialContext();
			System.out.println("InitialContext environment = " + initialContext.getEnvironment());
			_referenceFinderSvc = (IReferenceFinderSvcRemote) initialContext.lookup("jumpstart-max/ReferenceFinderSvc/remote");
			_referenceManagerSvc = (IReferenceManagerSvcRemote) initialContext.lookup("jumpstart-max/ReferenceManagerSvc/remote");
			_securityFinderSvc = (ISecurityFinderSvcRemote) initialContext.lookup("jumpstart-max/SecurityFinderSvc/remote");
			_securityManagerSvc = (ISecurityManagerSvcRemote) initialContext.lookup("jumpstart-max/SecurityManagerSvc/remote");
		}
		catch (NoInitialContextException e) {
			throw new RuntimeException("Could not locate services.  Is jndi.properties missing from the testing classpath?", e);
		}
		catch (NamingException e) {
			throw new RuntimeException(
					"Could not locate services.  Is JBoss server started?  Is jbossall-client.jar missing from the testing classpath?",
					e);
		}

	}

}
