package jumpstart.max.business;

import jumpstart.max.business.commons.exception.AddWhatExceptionTest;
import jumpstart.max.business.commons.exception.CannotDeleteIsNotEmptyExceptionTest;
import jumpstart.max.business.commons.exception.CannotDeleteIsReferencedExceptionTest;
import jumpstart.max.business.commons.exception.DoesNotExistExceptionTest;
import jumpstart.max.business.commons.exception.DuplicateAlternateKeyExceptionTest;
import jumpstart.max.business.commons.exception.DuplicatePrimaryKeyExceptionTest;
import jumpstart.max.business.commons.exception.GenericBusinessExceptionTest;
import jumpstart.max.business.commons.exception.OptimisticLockExceptionTest;
import jumpstart.max.business.commons.exception.ReferenceNotResettableExceptionTest;
import jumpstart.max.business.commons.exception.ReferencesWrongSubsetExceptionTest;
import jumpstart.max.business.commons.exception.RemoveWhatExceptionTest;
import jumpstart.max.business.commons.exception.ValueRequiredExceptionTest;
import jumpstart.max.business.commons.query.QueryBuilderTest;
import jumpstart.max.business.domain.examples.DateStuffTest;
import jumpstart.max.business.domain.security.UserPasswordTest;
import junit.framework.Test;
import junit.framework.TestSuite;

public class BusinessTestSuite {

	public static Test suite() {
		TestSuite suite = new TestSuite("Test jumpstart.business");
		// $JUnit-BEGIN$

		suite.addTest(new TestSuite(QueryBuilderTest.class));

		suite.addTest(new TestSuite(AddWhatExceptionTest.class));
		suite.addTest(new TestSuite(CannotDeleteIsNotEmptyExceptionTest.class));
		suite.addTest(new TestSuite(CannotDeleteIsReferencedExceptionTest.class));
		suite.addTest(new TestSuite(DoesNotExistExceptionTest.class));
		suite.addTest(new TestSuite(DuplicateAlternateKeyExceptionTest.class));
		suite.addTest(new TestSuite(DuplicatePrimaryKeyExceptionTest.class));
		suite.addTest(new TestSuite(GenericBusinessExceptionTest.class));
		suite.addTest(new TestSuite(OptimisticLockExceptionTest.class));
		suite.addTest(new TestSuite(ReferenceNotResettableExceptionTest.class));
		suite.addTest(new TestSuite(ReferencesWrongSubsetExceptionTest.class));
		suite.addTest(new TestSuite(RemoveWhatExceptionTest.class));
		suite.addTest(new TestSuite(ValueRequiredExceptionTest.class));

		suite.addTest(new TestSuite(DateStuffTest.class));
		suite.addTest(new TestSuite(UserPasswordTest.class));

		// $JUnit-END$
		return suite;
	}
}
