package jumpstart.max.business.commons.exception;

import jumpstart.max.business.BaseTest;
import jumpstart.max.business.domain.reference.CodeGroup;

public class AddWhatExceptionTest extends BaseTest {

	public AddWhatExceptionTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(AddWhatExceptionTest.class);
	}

	public void test_AddWhatException_is_thrown_on_adding_null_part_to_whole() {

		try {
			CodeGroup cg = _referenceFinderSvc.findCodeGroup("cod_status");
			_referenceManagerSvc.addCode(null, cg);
			fail("Should not reach here");
		}
		catch (Exception e) {
			BusinessException s = _interpreter.interpretAsBusinessException(e);
			assertEquals(s.getMessage(), AddWhatException.class, s.getClass());
			assertEquals("Cannot add Code to Code Group because Code not given.", s.getLocalizedMessage());
		}

	}

	public void test_AddWhatException_is_thrown_on_adding_null_part_to_whole_while_detached() {

		try {
			CodeGroup cg = _referenceFinderSvc.findCodeGroupShallowish("cod_status");
			cg.addCode(null);
			fail("Should not reach here");
		}
		catch (Exception e) {
			assertEquals(e.getMessage(), AddWhatException.class, e.getClass());
			assertEquals("Cannot add Code to Code Group because Code not given.", e.getLocalizedMessage());
		}

	}

}
