package jumpstart.max.business.commons.exception;

import jumpstart.max.business.BaseTest;
import jumpstart.max.business.domain.reference.CodeGroup;

public class CannotDeleteIsNotEmptyExceptionTest extends BaseTest {

	public CannotDeleteIsNotEmptyExceptionTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(CannotDeleteIsNotEmptyExceptionTest.class);
	}

	public void test_CannotDeleteIsNotEmptyException_is_thrown_on_deleting_whole_that_has_parts_without_cascade() {

		// Can't actually do this test on CannotDeleteIsNotEmptyException
		// because no entities currently use it - instead they all use cascaded
		// delete in their whole-part relationships.
		// So, below is an untested example of how it might work if CodeGroup
		// did use CannotDeleteIsNotEmptyException.

		if (false) { // ie. don't do this block
			try {
				CodeGroup cg = _referenceFinderSvc.findCodeGroupShallowish("cod_status");

				_referenceManagerSvc.deleteCodeGroup(cg);
				fail("Should not reach here");
			}
			catch (Exception e) {
				BusinessException s = _interpreter.interpretAsBusinessException(e);
				assertEquals(s.getMessage(), CannotDeleteIsNotEmptyException.class, s.getClass());
				assertEquals("Cannot delete CodeGroup \"cod_status\" because it still contains Code.", s
						.getLocalizedMessage());
			}
		}

	}

}
