package jumpstart.max.business.commons.exception;

import jumpstart.max.business.BaseTest;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.CodeGroup;

public class CannotDeleteIsReferencedExceptionTest extends BaseTest {

	public CannotDeleteIsReferencedExceptionTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(CannotDeleteIsReferencedExceptionTest.class);
	}

	public void test_CannotDeleteIsReferencedException_is_thrown_on_deleting_entity_that_is_referenced() {

		// Test remove, as opposed to delete

		try {
			Code c = _referenceFinderSvc.findCodeShallowish("usr_active");

			_referenceManagerSvc.removeCode(c);
			fail("Should not reach here");
		}
		catch (Exception e) {
			BusinessException s = _interpreter.interpretAsBusinessException(e);
			assertEquals(s.getMessage(), CannotDeleteIsReferencedException.class, s.getClass());
			CannotDeleteIsReferencedException x = (CannotDeleteIsReferencedException) s;
			if (x.getInformationLevel() == CannotDeleteIsReferencedException.INFORMATIONLEVEL_ENTITY_REFBYPROPERTY) {
				assertEquals("Cannot delete because there are references to it by \"type_code\".", s
						.getLocalizedMessage());
			}
			else if (x.getInformationLevel() == CannotDeleteIsReferencedException.INFORMATIONLEVEL_REFBYENTITY) {
				assertEquals("Cannot delete because there are references to it or its parts by \"USER\".", s
						.getLocalizedMessage());
			}
			else {
				fail("Information level = " + x.getInformationLevel());
			}
		}

	}

	public void test_CannotDeleteIsReferencedException_is_thrown_on_deleting_entity_that_is_referenced_circularly() {

		try {
			Code c = _referenceFinderSvc.findCodeShallowish("cod_active");

			_referenceManagerSvc.removeCode(c);
			fail("Should not reach here");
		}
		catch (Exception e) {
			BusinessException s = _interpreter.interpretAsBusinessException(e);
			assertEquals(s.getMessage(), CannotDeleteIsReferencedException.class, s.getClass());
			CannotDeleteIsReferencedException x = (CannotDeleteIsReferencedException) s;
			if (x.getInformationLevel() == CannotDeleteIsReferencedException.INFORMATIONLEVEL_ENTITY_REFBYPROPERTY) {
				assertEquals("Cannot delete because there are references to it by \"status_code\".", s
						.getLocalizedMessage());
			}
			else if (x.getInformationLevel() == CannotDeleteIsReferencedException.INFORMATIONLEVEL_REFBYENTITY) {
				assertEquals("Cannot delete because there are references to it or its parts by \"CODE\".", s
						.getLocalizedMessage());
			}
			else {
				fail("Information level = " + x.getInformationLevel());
			}
		}

	}

	public void test_CannotDeleteIsReferencedException_is_thrown_on_deleting_whole_whose_parts_are_referenced() {

		try {
			CodeGroup cg = _referenceFinderSvc.findCodeGroupShallowish("usr_status");

			_referenceManagerSvc.deleteCodeGroup(cg);
			fail("Should not reach here");
		}
		catch (Exception e) {
			BusinessException s = _interpreter.interpretAsBusinessException(e);
			assertEquals(s.getMessage(), CannotDeleteIsReferencedException.class, s.getClass());
			CannotDeleteIsReferencedException x = (CannotDeleteIsReferencedException) s;
			if (x.getInformationLevel() == CannotDeleteIsReferencedException.INFORMATIONLEVEL_ENTITY_REFBYPROPERTY) {
				assertEquals("Cannot delete because there are references to it by \"type_code\".", s
						.getLocalizedMessage());
			}
			else if (x.getInformationLevel() == CannotDeleteIsReferencedException.INFORMATIONLEVEL_REFBYENTITY) {
				assertEquals("Cannot delete because there are references to it or its parts by \"USER\".", s
						.getLocalizedMessage());
			}
			else {
				fail("Information level = " + x.getInformationLevel());
			}
		}

	}

	public void test_CannotDeleteIsReferencedException_is_thrown_on_deleting_whole_whose_parts_are_referenced_circularly() {

		try {
			CodeGroup cg = _referenceFinderSvc.findCodeGroupShallowish("cod_status");

			_referenceManagerSvc.deleteCodeGroup(cg);
			fail("Should not reach here");
		}
		catch (Exception e) {
			BusinessException s = _interpreter.interpretAsBusinessException(e);
			assertEquals(s.getMessage(), CannotDeleteIsReferencedException.class, s.getClass());
			CannotDeleteIsReferencedException x = (CannotDeleteIsReferencedException) s;
			if (x.getInformationLevel() == CannotDeleteIsReferencedException.INFORMATIONLEVEL_ENTITY_ID_REFBYENTITY_REFBYPROPERTY) {
				assertEquals("Cannot delete because there are references to it by \"Code.Status\".", s
						.getLocalizedMessage());
			}
			else if (x.getInformationLevel() == CannotDeleteIsReferencedException.INFORMATIONLEVEL_ENTITY_REFBYPROPERTY) {
				assertEquals("Cannot delete because there are references to it by \"status_code\".", s
						.getLocalizedMessage());
			}
			else {
				fail("Information level = " + x.getInformationLevel());
			}
		}

	}

}
