package jumpstart.max.business.commons.exception;

import jumpstart.max.business.BaseTest;

public class DoesNotExistExceptionTest extends BaseTest {

	public DoesNotExistExceptionTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(DoesNotExistExceptionTest.class);
	}

	public void test_DoesNotExistException_is_thrown_on_find_by_wrong_String_id() {

		try {
			_referenceFinderSvc.findCode("garbage");
			fail("Should not reach here");
		}
		catch (Exception e) {
			BusinessException s = _interpreter.interpretAsBusinessException(e);
			assertEquals(s.getMessage(), DoesNotExistException.class, s.getClass());
			assertEquals("Code \"garbage\" does not exist.", e.getLocalizedMessage());
		}

	}

	public void test_DoesNotExistException_is_thrown_on_find_shallowish_by_wrong_String_id() {

		try {
			_referenceFinderSvc.findCodeShallowish("garbage");
			fail("Should not reach here");
		}
		catch (Exception e) {
			BusinessException s = _interpreter.interpretAsBusinessException(e);
			assertEquals(s.getMessage(), DoesNotExistException.class, s.getClass());
			assertEquals("Code \"garbage\" does not exist.", e.getLocalizedMessage());
		}

	}

	public void test_DoesNotExistException_is_thrown_on_find_by_wrong_Long_id() {

		try {
			_securityFinderSvc.findUser(new Long(346746437));
			fail("Should not reach here");
		}
		catch (Exception e) {
			BusinessException s = _interpreter.interpretAsBusinessException(e);
			assertEquals(s.getMessage(), DoesNotExistException.class, s.getClass());
			assertEquals("User \"346,746,437\" does not exist.", s.getLocalizedMessage());
		}

	}

	public void test_DoesNotExistException_is_thrown_on_find_shallowish_by_wrong_Long_id() {

		try {
			_securityFinderSvc.findUserShallowish(new Long(346746437));
			fail("Should not reach here");
		}
		catch (Exception e) {
			BusinessException s = _interpreter.interpretAsBusinessException(e);
			assertEquals(s.getMessage(), DoesNotExistException.class, s.getClass());
			assertEquals("User \"346,746,437\" does not exist.", s.getLocalizedMessage());
		}

	}

}
