package jumpstart.max.business.commons.exception;

import jumpstart.max.business.BaseTest;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.security.Role;

public class DuplicateAlternateKeyExceptionTest extends BaseTest {

	public DuplicateAlternateKeyExceptionTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(DuplicateAlternateKeyExceptionTest.class);
	}

	public void test_DuplicateAlternateKeyException_is_thrown() {

		try {
			Role r1 = _securityFinderSvc.findRoleShallowish(new Long(1));

			Role r = new Role();
			r.setName(r1.getName());
			// To avoid LazyInitializationException inside the service when it's
			// creating the CodeGroup, we have to
			// get the real Status first... curious Hibernate behaviour
			Code status1 = _referenceFinderSvc.findCodeShallowish(r1.getStatus().getId());
			r.setStatus(status1);

			_securityManagerSvc.createRole(r);
			fail("Should not reach here");
		}
		catch (Exception e) {
			BusinessException s = _interpreter.interpretAsBusinessException(e);
			assertEquals(s.getMessage(), DuplicateAlternateKeyException.class, s.getClass());
			DuplicateAlternateKeyException d = (DuplicateAlternateKeyException) s;
			if (d.getInformationLevel() == DuplicateAlternateKeyException.INFORMATIONLEVEL_ENTITY_TECHMSG) {
				assertTrue(s.getLocalizedMessage().startsWith("Role already exists"));
			}
			else if (d.getInformationLevel() == DuplicateAlternateKeyException.INFORMATIONLEVEL_TECHMSG) {
				assertTrue(s.getLocalizedMessage().startsWith("Already exists"));
			}
			else {
				fail("Information level = " + d.getInformationLevel());
			}
		}

	}

}
