package jumpstart.max.business.commons.exception;

import jumpstart.max.business.BaseTest;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.CodeGroup;

public class DuplicatePrimaryKeyExceptionTest extends BaseTest {

	public DuplicatePrimaryKeyExceptionTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(DuplicatePrimaryKeyExceptionTest.class);
	}

	public void test_DuplicatePrimaryKeyException_is_thrown() {

		try {
			CodeGroup cg1 = _referenceFinderSvc.findCodeGroupShallowish("cod_status");

			CodeGroup cg = new CodeGroup();
			cg.setId(cg1.getId());
			cg.setDescription("x");
			cg.setShortDescription("x");
			// To avoid LazyInitializationException when we create theCodeGroup,
			// we have to get the real Status first... curious Hibernate
			// behaviour
			Code status1 = _referenceFinderSvc.findCodeShallowish(cg1.getStatus().getId());
			cg.setStatus(status1);

			_referenceManagerSvc.createCodeGroup(cg);
			fail("Should not reach here");
		}
		catch (Exception e) {
			BusinessException s = _interpreter.interpretAsBusinessException(e);
			if (s instanceof DuplicatePrimaryKeyException) {
				DuplicatePrimaryKeyException d = (DuplicatePrimaryKeyException) s;
				if (d.getInformationLevel() == DuplicatePrimaryKeyException.INFORMATIONLEVEL_ID) {
					assertEquals("\"cod_status\" already exists.", d.getLocalizedMessage());
				}
				else if (d.getInformationLevel() == DuplicatePrimaryKeyException.INFORMATIONLEVEL_NONE) {
					assertEquals("Already exists.", d.getLocalizedMessage());
				}
				else {
					fail("d.getInformationLevel() = " + d.getInformationLevel());
				}
			}
			else {
				fail(e.getLocalizedMessage());
			}
		}
	}

}
