package jumpstart.max.business.commons.exception;

import jumpstart.max.business.BaseTest;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.CodeGroup;

public class GenericBusinessExceptionTest extends BaseTest {
	private static String NONSENSE_ID = "nonsense";

	public GenericBusinessExceptionTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(GenericBusinessExceptionTest.class);
	}

	public void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();

		// Get code group "nonsense" and delete it.

		CodeGroup cg_nonsense = _referenceFinderSvc.findCodeGroup(NONSENSE_ID);
		_referenceManagerSvc.deleteCodeGroup(cg_nonsense);

		// Get code "cgr_active" and set its status to active.

		Code cgr_active = _referenceFinderSvc.findCodeShallowish("cgr_active");
		Code cod_active = _referenceFinderSvc.findCodeShallowish("cod_active");
		cgr_active.setStatus(cod_active);
		_referenceManagerSvc.changeCode(cgr_active);
	}

	public void test_GenericBusinessException_is_thrown_in_a_specific_CodeGroup_validation() throws BusinessException {

		// Create code group "nonsense" with its status set to inactive. Expect it to work.

		CodeGroup cg_nonsense = new CodeGroup();
		Code cgr_inactive = _referenceFinderSvc.findCodeShallowish("cgr_inactive");

		cg_nonsense.setId(NONSENSE_ID);
		cg_nonsense.setDescription("x");
		cg_nonsense.setShortDescription("y");
		cg_nonsense.setStatus(cgr_inactive);
		_referenceManagerSvc.createCodeGroup(cg_nonsense);

		// Get code "cgr_active" and set its status to inactive.

		Code cgr_active = _referenceFinderSvc.findCodeShallowish("cgr_active");
		Code cod_inactive = _referenceFinderSvc.findCodeShallowish("cod_inactive");
		cgr_active.setStatus(cod_inactive);
		_referenceManagerSvc.changeCode(cgr_active);

		// Change code group "nonsense" status to active. Expect it to fail because active is itself inactive!

		try {
			cg_nonsense.setStatus(cgr_active);
			_referenceManagerSvc.createCodeGroup(cg_nonsense);
		}
		catch (Exception e) {
			BusinessException s = _interpreter.interpretAsBusinessException(e);
			assertEquals(s.getMessage(), GenericBusinessException.class, s.getClass());
			assertEquals("Choose a status that is active.  Status \"Active\" is code \"cgr_active\" which is not currently active.", s.getLocalizedMessage());
		}

	}

}
