package jumpstart.max.business.commons.exception;

import jumpstart.max.business.BaseTest;
import jumpstart.max.business.domain.reference.CodeGroup;

public class OptimisticLockExceptionTest extends BaseTest {

	public OptimisticLockExceptionTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(OptimisticLockExceptionTest.class);
	}

	public void test_OptimisticLockException_is_thrown() {

		CodeGroup cg1 = null;
		String d1 = null;
		CodeGroup cg2 = null;

		// Get a CodeGroup twice and change the first instance - expect no
		// exceptions

		try {
			cg1 = _referenceFinderSvc.findCodeGroupShallowish("cod_status");
			cg2 = _referenceFinderSvc.findCodeGroupShallowish("cod_status");
			d1 = cg1.getDescription();
			cg1.setDescription(d1 + "z");
			_referenceManagerSvc.changeCodeGroup(cg1);
		}
		catch (Exception e) {
			fail("Should not reach here");
		}

		// Now change the second instance - expect optimistic lock exception

		try {
			cg2.setDescription(d1 + "y");
			_referenceManagerSvc.changeCodeGroup(cg2);
			fail("Should not reach here");
		}
		catch (Exception e) {
			BusinessException s = _interpreter.interpretAsBusinessException(e);
			assertEquals(s.getMessage(), OptimisticLockException.class, e.getClass());
			assertEquals("Not saved or deleted because it has been changed or deleted by others since displayed.", s
					.getLocalizedMessage());
		}

		// Undo change to cg1

		try {
			cg1 = _referenceFinderSvc.findCodeGroupShallowish("cod_status");
			cg1.setDescription(d1);
			_referenceManagerSvc.changeCodeGroup(cg1);
		}
		catch (Exception e) {
			fail("Should not reach here");
		}

	}

}
