package jumpstart.max.business.commons.exception;

import jumpstart.max.business.BaseTest;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.CodeGroup;

public class ReferenceNotResettableExceptionTest extends BaseTest {

	public ReferenceNotResettableExceptionTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(ReferenceNotResettableExceptionTest.class);
	}

	public void test_ReferenceNotResettableException_is_thrown_on_changing_part_to_reference_different_whole() {

		// Test that the integrity of a whole-part relationship is maintained by
		// getting a Code then trying to change which CodeGroup it references - expect an exception

		try {
			Code c = _referenceFinderSvc.findCodeShallowish("cgr_active");
			CodeGroup cg1 = _referenceFinderSvc.findCodeGroupShallowish("usr_status");
			assertFalse(c.getCodeGroup().equals(cg1));
			c.setCodeGroup(cg1);
			_referenceManagerSvc.changeCode(c);
			fail("Should not reach here");
		}
		catch (Exception e) {
			BusinessException s = _interpreter.interpretAsBusinessException(e);
			assertEquals(s.getMessage(), ReferenceNotMutableException.class, s.getClass());
			assertEquals("Do not reset Code Group of Code.  Id was \"cgr_status\" and would have become \"usr_status\".", s
					.getLocalizedMessage());
		}

	}

}
