package jumpstart.max.business.commons.exception;

import jumpstart.max.business.BaseTest;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.CodeGroup;

public class ReferencesWrongSubsetExceptionTest extends BaseTest {

	public ReferencesWrongSubsetExceptionTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(ReferencesWrongSubsetExceptionTest.class);
	}

	public void test_ReferencesWrongSubsetException_is_thrown_on_referencing_a_part_of_wrong_whole() {

		try {
			CodeGroup cg = new CodeGroup();

			cg.setId("garbage");
			cg.setDescription("x");
			cg.setShortDescription("y");
			Code c1 = _referenceFinderSvc.findCodeShallowish("usr_active");
			cg.setStatus(c1);

			_referenceManagerSvc.createCodeGroup(cg);
			fail("Should not reach here");
		}
		catch (Exception e) {
			BusinessException s = _interpreter.interpretAsBusinessException(e);
			assertEquals(s.getMessage(), ReferencesWrongSubsetException.class, s.getClass());
			assertEquals(
					"Status must be from Code Group \"cgr_status\", but \"usr_active\" is from Code Group \"usr_status\".",
					s.getLocalizedMessage());
		}

	}

	public void test_ReferencesWrongSubsetException_is_thrown_on_referencing_a_part_of_wrong_whole_while_detached() {

		try {
			CodeGroup cg = new CodeGroup();

			cg.setId("garbage");
			cg.setDescription("x");
			cg.setShortDescription("y");
			Code c1 = _referenceFinderSvc.findCodeShallowish("usr_active");
			cg.setStatus(c1);

			cg.validateCodeGroup();
			fail("Should not reach here");
		}
		catch (Exception e) {
			assertEquals(e.getMessage(), ReferencesWrongSubsetException.class, e.getClass());
			assertEquals(
					"Status must be from Code Group \"cgr_status\", but \"usr_active\" is from Code Group \"usr_status\".",
					e.getLocalizedMessage());
		}

	}

}
