package jumpstart.max.business.commons.exception;

import javax.ejb.EJBException;

import jumpstart.max.business.BaseTest;
import jumpstart.max.business.domain.reference.CodeGroup;

public class RemoveWhatExceptionTest extends BaseTest {

	public RemoveWhatExceptionTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(RemoveWhatExceptionTest.class);
	}

	public void test_RemoveWhatException_is_thrown_on_removing_null_part_from_whole() {

		// Don't expect a RemoveWhatException - instead, expect the service to fail with EJBException wrapping an
		// IllegalArgumentException

		try {
			_referenceManagerSvc.removeCode(null);
			fail("Should not reach here");
		}
		catch (EJBException e) {
			assertEquals(e.getMessage(), EJBException.class, e.getClass());
			Exception causedBy = e.getCausedByException();
			assertEquals(IllegalArgumentException.class, causedBy.getClass());
		}
		catch (Throwable t) {
			fail("Should not reach here");
		}

	}

	public void test_RemoveWhatException_is_thrown_on_removing_null_part_from_whole_while_detached() {

		try {
			CodeGroup cg = _referenceFinderSvc.findCodeGroup("cod_status");
			cg.removeCode(null);
			fail("Should not reach here");
		}
		catch (Exception e) {
			assertEquals(e.getMessage(), RemoveWhatException.class, e.getClass());
			assertEquals("Cannot remove Code from Code Group because Code not given.", e.getLocalizedMessage());
		}

	}

}
