package jumpstart.max.business.commons.exception;

import jumpstart.max.business.BaseTest;
import jumpstart.max.business.domain.reference.CodeGroup;

public class ValueRequiredExceptionTest extends BaseTest {

	public ValueRequiredExceptionTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(ValueRequiredExceptionTest.class);
	}

	public void test_ValueRequiredException_is_thrown_when_creating_entity_with_required_reference_nulled() {

		try {
			CodeGroup cg = new CodeGroup();
			cg.setId("garbage");
			_referenceManagerSvc.createCodeGroup(cg);
			fail("Should not reach here");
		}
		catch (Exception e) {
			BusinessException s = _interpreter.interpretAsBusinessException(e);
			assertEquals(s.getMessage(), ValueRequiredException.class, e.getClass());
			assertEquals("You must enter a value for Status.", e.getLocalizedMessage());
		}

	}

	public void test_ValueRequiredException_is_thrown_when_changing_entity_with_required_reference_nulled() {

		try {
			CodeGroup cg = _referenceFinderSvc.findCodeGroupShallowish("usr_status");
			cg.setStatus(null);
			_referenceManagerSvc.changeCodeGroup(cg);
			fail("Should not reach here");
		}
		catch (Exception e) {
			BusinessException s = _interpreter.interpretAsBusinessException(e);
			assertEquals(s.getMessage(), ValueRequiredException.class, s.getClass());
			assertEquals("You must enter a value for Status.", s.getLocalizedMessage());
		}

	}

	public void test_ValueRequiredException_is_thrown_when_changing_entity_with_required_string_empty() {

		try {
			CodeGroup cg = _referenceFinderSvc.findCodeGroupShallowish("usr_status");
			cg.setDescription("");
			_referenceManagerSvc.changeCodeGroup(cg);
			fail("Should not reach here");
		}
		catch (Exception e) {
			BusinessException s = _interpreter.interpretAsBusinessException(e);
			assertEquals(s.getMessage(), ValueRequiredException.class, s.getClass());
			assertEquals("You must enter a value for Description.", s.getLocalizedMessage());
		}

	}

	public void test_ValueRequiredException_is_thrown_when_creating_entity_with_required_reference_nulled_while_detached() {

		try {
			CodeGroup cg = new CodeGroup();
			cg.setId("garbage");
			cg.validateCodeGroup();
			fail("Should not reach here");
		}
		catch (Exception e) {
			assertEquals(e.getMessage(), ValueRequiredException.class, e.getClass());
			assertEquals("You must enter a value for Status.", e.getLocalizedMessage());
		}

	}

	public void test_ValueRequiredException_is_thrown_when_changing_entity_with_required_reference_nulled_while_detached() {

		try {
			CodeGroup cg = _referenceFinderSvc.findCodeGroupShallowish("usr_status");
			cg.setStatus(null);
			cg.validateCodeGroup();
			fail("Should not reach here");
		}
		catch (Exception e) {
			assertEquals(e.getMessage(), ValueRequiredException.class, e.getClass());
			assertEquals("You must enter a value for Status.", e.getLocalizedMessage());
		}

	}

	public void test_ValueRequiredException_is_thrown_when_changing_entity_with_required_string_empty_while_detached() {

		try {
			CodeGroup cg = _referenceFinderSvc.findCodeGroupShallowish("usr_status");
			cg.setDescription("");
			cg.validateCodeGroup();
			fail("Should not reach here");
		}
		catch (Exception e) {
			assertEquals(e.getMessage(), ValueRequiredException.class, e.getClass());
			assertEquals("You must enter a value for Description.", e.getLocalizedMessage());
		}

	}

}
