package jumpstart.max.business.domain.examples;

import jumpstart.max.business.BaseTest;
import jumpstart.max.business.domain.security.UserPasswordTest;

import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class DateStuffTest extends BaseTest {

	public DateStuffTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(UserPasswordTest.class);
	}

	public void test_dateTime_get_set_doesnt_mutate() {

		// Try creating user with null password

		DateStuff ds = new DateStuff();

		DateTime dt = new DateTime(2007, 12, 31, 18, 19, 20, 123);
		ds.setDateTime(dt);
		DateTime dt1 = ds.getADateTime();
		assertEquals(dt, dt1);
	}

	public void test_dateMidnight_get_set_doesnt_mutate() {

		// Try creating user with null password

		DateStuff ds = new DateStuff();

		DateMidnight dm = new DateMidnight(2007, 12, 31);
		ds.setDateMidnight(dm);
		DateMidnight dm1 = ds.getADateMidnight();
		assertEquals(dm, dm1);
	}

	public void test_localDateTime_get_set_doesnt_mutate() {

		// Try creating user with null password

		DateStuff ds = new DateStuff();

		LocalDateTime ldt = new LocalDateTime(2007, 12, 31, 18, 19, 20, 123);
		ds.setLocalDateTime(ldt);
		LocalDateTime dt1 = ds.getALocalDateTime();
		assertEquals(ldt, dt1);
	}

	public void test_localDate_get_set_doesnt_mutate() {

		// Try creating user with null password

		DateStuff ds = new DateStuff();

		LocalDate ld = new LocalDate(2007, 12, 31);
		ds.setLocalDate(ld);
		LocalDate dt1 = ds.getALocalDate();
		assertEquals(ld, dt1);
	}

	public void test_localTime_get_set_doesnt_mutate() {

		// Try creating user with null password

		DateStuff ds = new DateStuff();

		LocalTime lt = new LocalTime(18, 19, 20, 123);
		ds.setLocalTime(lt);
		LocalTime dt1 = ds.getALocalTime();
		assertEquals(lt, dt1);
	}

}
