package jumpstart.max.business.domain.security;

import jumpstart.max.business.BaseTest;
import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.commons.exception.GenericBusinessException;
import jumpstart.max.business.commons.exception.ValueRequiredException;
import jumpstart.max.business.domain.reference.Code;

public class UserPasswordTest extends BaseTest {
	private User _john = null;
	private User _mrDeleteMe = null;

	public UserPasswordTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(UserPasswordTest.class);
	}

	public void setUp() throws Exception {
		super.setUp();

		if (_john == null) {
			_john = getJohn();
			_mrDeleteMe = setUpMrDeleteMe();
		}
	}

	public User getJohn() {
		User john = null;

		// Get user 3 and ensure that it is "john".

		try {
			john = _securityFinderSvc.findUserShallowish(new Long(3));
		}
		catch (Exception e) {
			fail(e.getMessage());
		}
		assertEquals("john", john.getLoginId());

		// Change his password to "john". OK if already is.

		try {
			_securityManagerSvc.changeUserPassword(john.getId(), "john");
		}
		catch (GenericBusinessException e) {
			assertEquals("User_newpassword_is_same", e.getMessageId());
		}
		catch (Exception e) {
			fail(e.getMessage());
		}

		return john;
	}

	public User setUpMrDeleteMe() throws Exception {

		User newUser = new User();

		newUser.setLoginId("DeleteMe");
		newUser.setSalutation(_john.getSalutation());
		// To avoid LazyInitializationException inside the service when it's
		// creating the User, we have to
		// get the real codes first... curious Hibernate behaviour
		Code salutation = _referenceFinderSvc.findCodeShallowish(_john.getSalutation().getId());
		newUser.setSalutation(salutation);
		Code status = _referenceFinderSvc.findCodeShallowish(_john.getStatus().getId());
		newUser.setSalutation(status);
		newUser.setFirstName("Delete");
		newUser.setLastName("Me");

		return newUser;
	}

	public void test_null_password_is_rejected_on_create_and_change_of_user() {

		// Try creating user with null password

		try {
			User u = _securityManagerSvc.createUser(_mrDeleteMe, null);

			// Oops
			_securityManagerSvc.deleteUser(u);
			fail("Should not reach here");
		}
		catch (BusinessException e) {
			assertTrue(e instanceof ValueRequiredException);
		}

		// Try changing existing password to null - 1st signature

		try {
			_securityManagerSvc.changeUserPassword(_john.getId(), null);
			fail("Should not reach here");
		}
		catch (BusinessException e) {
			assertTrue(e instanceof ValueRequiredException);
		}

		// Try changing existing password to null - 2nd signature

		try {
			_securityManagerSvc.changeUserPassword(_john.getId(), "john", null);
			fail("Should not reach here");
		}
		catch (BusinessException e) {
			assertTrue(e instanceof ValueRequiredException);
		}

	}

	public void test_blank_password_is_rejected_on_create_and_change_of_user() {

		// Try creating user with blank password

		try {
			User u = _securityManagerSvc.createUser(_mrDeleteMe, "");

			// Oops
			_securityManagerSvc.deleteUser(u);
			fail("Should not reach here");
		}
		catch (BusinessException e) {
			assertTrue(e instanceof ValueRequiredException);
		}

		// Try changing existing password to blank - 1st signature

		try {
			_securityManagerSvc.changeUserPassword(_john.getId(), "");
			fail("Should not reach here");
		}
		catch (BusinessException e) {
			assertTrue(e instanceof ValueRequiredException);
		}

		// Try changing existing password to blank - 2nd signature

		try {
			_securityManagerSvc.changeUserPassword(_john.getId(), "john", "");
			fail("Should not reach here");
		}
		catch (BusinessException e) {
			assertTrue(e instanceof ValueRequiredException);
		}

	}

	public void test_unchanged_password_is_rejected_on_changing_user_password() {

		// Try changing password to same as it is now - 1st signature

		try {
			_securityManagerSvc.changeUserPassword(_john.getId(), "john");
		}
		catch (GenericBusinessException e) {
			assertEquals("User_newpassword_is_same", e.getMessageId());
		}
		catch (Exception e) {
			fail(e.getMessage());
		}

		// Try changing password to same as it is now - 2nd signature

		try {
			_securityManagerSvc.changeUserPassword(_john.getId(), "john", "john");
		}
		catch (GenericBusinessException e) {
			assertEquals("User_newpassword_is_same", e.getMessageId());
		}
		catch (Exception e) {
			fail(e.getMessage());
		}

	}

	public void test_current_password_must_be_provided_on_changing_password() {

		try {
			_securityManagerSvc.changeUserPassword(_john.getId(), "bogus", "john");
			fail("Should not reach here");
		}
		catch (GenericBusinessException e) {
			assertEquals("User_password_incorrect", e.getMessageId());
		}
		catch (Exception e) {
			fail(e.getMessage());
		}

	}

}
