// Based on http://thread.gmane.org/gmane.comp.java.tapestry.user/43965

package jumpstart.max.web.commons.annotations;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.MethodSignature;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.annotations.AnnotationUtils;
import org.apache.tapestry.annotations.MethodAnnotationEnhancementWorker;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.spec.IComponentSpecification;

/**
 * @author Ming Jiang
 */

public class InjectExternalLinkAnnotationWorker implements MethodAnnotationEnhancementWorker {

	public void performEnhancement(EnhancementOperation op, IComponentSpecification spec, Method method,
			Location location) {
		if (!method.getReturnType().equals(ILink.class))
			throw new ApplicationRuntimeException("injectExternalLink annotation must return ILink");

		InjectExternalLink injectExternalLink = method.getAnnotation(InjectExternalLink.class);

		String pageName = injectExternalLink.value();

		BodyBuilder builder = new BodyBuilder();

		builder.begin();

		Class[] parameterTypes = method.getParameterTypes();
		int paramCount = Tapestry.size(parameterTypes);

		if (paramCount > 0) {
			if (parameterTypes[0].isArray()) {
				builder
						.addln(
								"return getPage().getRequestCycle().getInfrastructure().getServiceMap().getService(org.apache.tapestry.Tapestry.EXTERNAL_SERVICE).getLink(false, new org.apache.tapestry.engine.ExternalServiceParameter(\"{0}\",$1));",
								pageName);
			}
			else {
				builder.addln("java.lang.Object[] params = new java.lang.Object[{0}];", paramCount);
				for (int i = 0; i < paramCount; i++) {
					builder.add("params[{0}] = ", i);
					if (parameterTypes[i].isPrimitive())
						builder.add("($w) ");
					builder.addln("${0};", i + 1);
				}
				builder
						.addln(
								"return getPage().getRequestCycle().getInfrastructure().getServiceMap().getService(org.apache.tapestry.Tapestry.EXTERNAL_SERVICE).getLink(false, new org.apache.tapestry.engine.ExternalServiceParameter(\"{0}\",params));",
								pageName);
			}
		}

		builder.end();

		op.addMethod(Modifier.PUBLIC, new MethodSignature(method), builder.toString(), location);

		if (isGetter(method))
			op.claimReadonlyProperty(AnnotationUtils.getPropertyName(method));
	}

	boolean isGetter(Method method) {
		return method.getName().startsWith("get") && method.getParameterTypes().length == 0;
	}
}
