// Based on http://thread.gmane.org/gmane.comp.java.tapestry.user/43965

package jumpstart.max.web.commons.annotations;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.MethodSignature;
import org.apache.tapestry.annotations.AnnotationUtils;
import org.apache.tapestry.annotations.MethodAnnotationEnhancementWorker;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.spec.IComponentSpecification;

/**
 * @author Ming Jiang
 */

public class InjectPageLinkAnnotationWorker implements MethodAnnotationEnhancementWorker {

	public void performEnhancement(EnhancementOperation op, IComponentSpecification spec, Method method,
			Location location) {
		if (!method.getReturnType().equals(ILink.class))
			throw new ApplicationRuntimeException("InjectPageLink annotation must return ILink");

		InjectPageLink injectPageLink = method.getAnnotation(InjectPageLink.class);

		String pageName = injectPageLink.value();

		BodyBuilder builder = new BodyBuilder();

		builder.begin();
		builder
				.addln(
						"return getPage().getRequestCycle().getInfrastructure().getServiceMap().getService(org.apache.tapestry.Tapestry.PAGE_SERVICE).getLink(false,\"{0}\");",
						pageName);

		builder.end();

		op.addMethod(Modifier.PUBLIC, new MethodSignature(method), builder.toString(), location);

		if (isGetter(method))
			op.claimReadonlyProperty(AnnotationUtils.getPropertyName(method));
	}

	boolean isGetter(Method method) {
		return method.getName().startsWith("get") && method.getParameterTypes().length == 0;
	}
}
