// Based on org.apache.tapestry.callback.* in Tapestry 4.0.2,
// adds getLink method to ICallback.
// Might be added to Tapestry framework - for progress see
// https://issues.apache.org/jira/browse/TAPESTRY-1429

// Copyright 2004, 2005 The Apache Software Foundation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.package jumpstart.max.web.commons.callback;

//package org.apache.tapestry.callback;
package jumpstart.max.web.commons.callback;

import java.io.Serializable;

import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.ILink;

/**
 *  Defines a callback, an object which is used to invoke or reinvoke a method
 *  on an object or component in a later request cycle.  This is used to
 *  allow certain operations (say, submitting an order) to defer to other processes
 *  (say, logging in and/or registerring).
 *
 *  <p>Callbacks must be {@link Serializable}, to ensure that they can be stored
 *  between request cycles.
 *
 *  @author Howard Lewis Ship
 *  @since 0.2.9
 *
 **/

//public interface ICallback extends Serializable
public interface ICallbackJS extends Serializable
{
    /**
     *  Performs the call back.  Typical implementation will locate a particular
     *  page or component and invoke a method upon it, or 
     *  invoke a method on the {@link IRequestCycle cycle}.
     *
     **/

    public void performCallback(IRequestCycle cycle);

    /**
     *  Returns an ILink to the call back which can be used for redirect-after-post..
     *
     **/

    public ILink getLink(IRequestCycle cycle);
}
