//
// From http://thread.gmane.org/gmane.comp.java.tapestry.user/9641/focus=9650
// with modifications.  See also http://thread.gmane.org/gmane.comp.java.tapestry.user/33358/focus=34182
//
 
package jumpstart.max.web.commons.form;
 
import java.io.Serializable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
 
/**
 * Implementation of Synchronizer Token J2EE Patterns for Tapestry.
 *
 * Inclusion in Tapestry page template: <code>
 * &lt;input jwcid="@Hidden" value="ognl:visit.flowSynchronizer.token"/&gt;
 * </code>
 *
 * In case of a 2nd form in the same page: <code>
 * &lt;input jwcid="@Hidden" value="ognl:visit.flowSynchronizer.tokenCopy"/&gt;
 * </code>
 *
 * @author Bernhard Woditschka
 */
@SuppressWarnings("serial")
public class FlowSynchronizer implements Serializable {
	static private final Log LOG = LogFactory.getLog(FlowSynchronizer.class);
	
    private long _sequence;
    private String _token;
    private boolean _reSubmission = false;
 
    public FlowSynchronizer() {
        // initialize the sequence randomly
        _sequence = (long) (Math.random() * Long.MAX_VALUE / 2l);
    }
 
    public String getToken() {
        // generate a new token
        _token = Long.toHexString(++_sequence);
        LOG.debug(">>>>>>> Issuing token = " + _token);
        return _token;
    }
 
    public synchronized void setToken(String token) {
        // first compare the token
        if (_token == null || !_token.equals(token)) {
            LOG.debug(">>>>>>> RE-SUBMITTED!!!!!  Client token = " + token + ", session token = " + _token + ".");
            _reSubmission = true;
        } else {
            // reset token on match -> subsequent duplicate submission will fail
            LOG.debug(">>>>>>> Fresh submission.    Tokens match with " + _token + ".  Setting them to null. I am " + this);
            _token = null;
            _reSubmission = false;
        }
    }
 
    public String getTokenCopy() {
        return _token;
    }
 
    public void setTokenCopy(String tokenCopy) {
        setToken(_token);
    }
 
    public boolean isResubmission() {
    	LOG.debug(">>> reSubmission = " + _reSubmission);
        return _reSubmission;
    }
}
