// From http://wiki.apache.org/tapestry/SpeclessPagesInWEB-INF
//
// Enables you to put your .html files in WEB-INF even when there is no corresponding .page file.
// Actually, it looks for files with a given templateExtension (eg. ".html") relative to your 
// application specification (eg. WEB=INF/jumpstart.application).
//
// Configuration of this class is in hivemodule.xml.

package jumpstart.max.web.commons.resolver;

import org.apache.hivemind.Resource;
import org.apache.hivemind.impl.LocationImpl;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.resolver.ISpecificationResolverDelegate;
import org.apache.tapestry.spec.ComponentSpecification;
import org.apache.tapestry.spec.IComponentSpecification;

public class AppSpecRelativeSpecificationResolverDelegate implements ISpecificationResolverDelegate {
	private String templateExtension;

	public IComponentSpecification findPageSpecification(IRequestCycle cycle, INamespace namespace,
			String simplePageName) {
		String templateName = simplePageName + getTemplateExtension();
		Resource namespaceLocation = namespace.getSpecificationLocation();
		Resource templateResource = namespaceLocation.getRelativeResource(templateName);
		if (templateResource.getResourceURL() != null) {
			return setupImplicitPage(simplePageName, templateResource, namespaceLocation);
		}

		return null;
	}

	public IComponentSpecification findComponentSpecification(IRequestCycle cycle, INamespace namespace, String type) {
		return null;
	}

	private String getTemplateExtension() {
		return templateExtension;
	}

	private IComponentSpecification setupImplicitPage(String simpleName, Resource resource, Resource namespaceLocation) {
		Resource pageResource = namespaceLocation.getRelativeResource(simpleName + ".page");

		IComponentSpecification specification = new ComponentSpecification();
		specification.setPageSpecification(true);
		specification.setSpecificationLocation(pageResource);
		specification.setLocation(new LocationImpl(resource));

		return specification;
	}

	public void setTemplateExtension(String extension) {
		if (extension.charAt(0) != '.')
			extension = "." + extension;

		templateExtension = extension;
	}
}