// DateMidnightTranslator is a wrapper around Tapestry 4.1.2's DateTranslator class.
// Whereas DateTranslator translates between java's String and Date classes,
// DateMidnightTranslator translates between java's String class and joda-time's DateMidnight class.

package jumpstart.max.web.commons.translator;

import java.text.Format;
import java.util.Date;
import java.util.Locale;

import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.form.ValidationMessages;
import org.apache.tapestry.form.translator.DateTranslator;
import org.apache.tapestry.valid.ValidatorException;
import org.joda.time.DateMidnight;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateMidnightTranslator extends DateTranslator {
	protected boolean _pivotYearWasSpecified;
	protected int _pivotYear;

	public DateMidnightTranslator() {
	}

	// Needed until HIVEMIND-134 fix is available
	public DateMidnightTranslator(String initializer) {
		super(initializer);
	}

	public void setPivotYear(int pivotYear) {
		_pivotYearWasSpecified = true;
		_pivotYear = pivotYear;
	}

	/**
	 * @see org.apache.tapestry.form.translator.FormatTranslator#defaultPattern()
	 */
	@Override
	protected String defaultPattern() {
		return "yyyy-MM-dd";
	}

	@Override
	protected Object parseText(IFormComponent field, ValidationMessages messages, String text) throws ValidatorException {
		DateTimeFormatter dateTimeFormatter = null;
		Object obj = null;

		dateTimeFormatter = DateTimeFormat.forPattern(getPattern());
		try {
			if (_pivotYearWasSpecified) {
				obj = dateTimeFormatter.withPivotYear(_pivotYear).parseDateTime(text);
			}
			else {
				obj = dateTimeFormatter.parseDateTime(text);
			}
		}
		catch (IllegalArgumentException e) {
			throw new ValidatorException(buildMessage(messages, field, getMessageKey()), getConstraint());
		}
		
		DateMidnight dm = new DateMidnight(obj);
		return dm;
	}

	// @Override
	// protected Object parseText(IFormComponent field, ValidationMessages
	// messages, String text) throws ValidatorException {
	// Object obj = super.parseText(field, messages, text);
	// DateMidnight dm = new DateMidnight(obj);
	// System.out.println(">>>>>>>>> " +
	// DateTimeFormat.forStyle("M-").print(dm));
	// return dm;
	// }

	@Override
	protected String formatObject(IFormComponent field, Locale locale, Object object) {
		// Get a new format each time, because (a) have to account for locale
		// and (b) formatters are not thread safe.

		Date date = ((DateMidnight) object).toDate();
		Format format = getFormat(locale);
		return format.format(date);
	}

}
