/*
 
 Here's why MinDateISO and MaxDateISO are necessary...

 The minDate and maxDate validators are not portable across application servers
or locales.  For example minDate=7/1/2005 is accepted by Tomcat but JBoss
will reject it because it expects something like minDate=Sep 1, 2005
(see http://thread.gmane.org/gmane.comp.java.tapestry.user/28533)

So I wrote portable alternatives that ALWAYS expect a yyyy-MM-dd string. 
They're called minDateISO and maxDateISO.  Suggestions to improve them are
very welcome.

-- Here's how you might use them in your html:

validators=
"validators:required,minDateISO=1999-01-01,maxDateISO=2069-12-31"

-- eg.

<input jwcid=" <at> DatePicker" value="ognl:order.date"
translator="translator:date,pattern=dd MMM yyyy" displayName="Order date"
validators="validators:required,minDateISO=1970-01-01,
maxDateISO=2069-12-31">1 Sep 2005</input>

*/

package jumpstart.max.web.commons.validator;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.tapestry.form.validator.MaxDate;

public class MaxDateISO extends MaxDate {
	private static final String isoFormatStr = "yyyy-MM-dd";
	private static final DateFormat isoDateFormat = new SimpleDateFormat(isoFormatStr);

	public void setMaxDateISO(String maxDateISO) {
		try {
			Date date = isoDateFormat.parse(maxDateISO);
			super.setMaxDate(date);
		}
		catch (ParseException e) {
			throw new IllegalArgumentException("Value received for maxDateISO is \"" + maxDateISO
					+ "\" which does not match format \"" + isoFormatStr + "\".", e);
		}
	}

}
