package jumpstart.max.web.components;

import jumpstart.max.web.pages.login.AboutPage;
import jumpstart.max.web.pages.login.HelpPage;
import jumpstart.max.web.pages.login.OptionsEditPage;
import jumpstart.max.web.pages.reference.CodeGroupSearchPage;
import jumpstart.max.web.pages.reference.CodeSearchPage;
import jumpstart.max.web.pages.security.MyProfileViewPage;
import jumpstart.max.web.pages.security.RoleSearchPage;
import jumpstart.max.web.pages.security.UserRoleSearchPage;
import jumpstart.max.web.pages.security.UserSearchPage;
import jumpstart.max.web.state.Visit;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.Asset;
import org.apache.tapestry.annotations.InjectObject;
import org.apache.tapestry.annotations.InjectState;
import org.apache.tapestry.annotations.Parameter;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.event.PageBeginRenderListener;
import org.apache.tapestry.event.PageEvent;

/**
 * Common navigational border for jumpstart.
 * 
 * @author Geoff Callender
 */

public abstract class Border extends BaseComponent implements PageBeginRenderListener {
	static private Log LOG = LogFactory.getLog(Border.class);
	static public final int STYLE_1 = 1;
	static public final int STYLE_2 = 2;

	//
	// INJECTION BUG WARNING...
	// If you suffer from the sporadic Tapestry 4.0 bug where injection
	// sometimes fails in components when annotations and
	// -Dorg.apache.tapestry.disable-caching=true are used together
	// then comment out the parameters and assets below
	// and uncomment their counterparts in Border.jwc
	//

	@Parameter(name = "tab", required = false, defaultValue = "")
	public abstract String getActiveTab();

	@Parameter(name = "subtab", required = false, defaultValue = "")
	public abstract String getActiveSubTab();

	@Asset("context:/css/global.css")
	public abstract IAsset getStylesheet1();

	@Asset("context:/css/global_stylish.css")
	public abstract IAsset getStylesheet2();

	@InjectState("visit")
	public abstract Visit getMyVisit();

	@InjectObject("engine-service:restart")
	public abstract IEngineService getRestartService();

	public void pageBeginRender(PageEvent event) {
	}

	public String getMyLoginId() {
		return getMyVisit().getMyLoginId();
	}

	public IAsset getStylesheet() {
		IAsset stylesheet;

		switch (getMyVisit().getStyleId()) {
		case Border.STYLE_1:
			stylesheet = getStylesheet1();
			break;

		case Border.STYLE_2:
			stylesheet = getStylesheet2();
			break;

		default:
			stylesheet = getStylesheet1();
			break;
		}

		return stylesheet;
	}

	public boolean isInspectorEnabled() {
		return getMyVisit().isInspectorEnabled();
	}

	//
	// Listeners for links at top of page
	//

	public void doMyProfile(IRequestCycle cycle) {
		MyProfileViewPage nextPage = (MyProfileViewPage) cycle.getPage(MyProfileViewPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doOptions(IRequestCycle cycle) {
		OptionsEditPage nextPage = (OptionsEditPage) cycle.getPage(OptionsEditPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doHelp(IRequestCycle cycle) {
		HelpPage nextPage = (HelpPage) cycle.getPage(HelpPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doAbout(IRequestCycle cycle) {
		AboutPage nextPage = (AboutPage) cycle.getPage(AboutPage.PAGE_NAME);
		nextPage.activate();
	}

	public ILink doLogout(IRequestCycle cycle) {
		LOG.info(getMyVisit().getMyLoginId() + " is logging out.");

		// Redirect to the restart service, which will destroy the session and
		// therefore cleans up our Visit

		ILink redirectTo = getRestartService().getLink(false, null);
		return redirectTo;
	}

	//
	// Listeners for tabs
	//

	public void doReferenceTab(IRequestCycle cycle) {
		CodeGroupSearchPage nextPage = (CodeGroupSearchPage) cycle.getPage(CodeGroupSearchPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doSecurityTab(IRequestCycle cycle) {
		UserSearchPage nextPage = (UserSearchPage) cycle.getPage(UserSearchPage.PAGE_NAME);
		nextPage.activate();
	}

	//
	// Listeners for sub tabs
	//

	public void doCodeSubTab(IRequestCycle cycle) {
		CodeSearchPage nextPage = (CodeSearchPage) cycle.getPage(CodeSearchPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doCodeGroupSubTab(IRequestCycle cycle) {
		CodeGroupSearchPage nextPage = (CodeGroupSearchPage) cycle.getPage(CodeGroupSearchPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doRoleSubTab(IRequestCycle cycle) {
		RoleSearchPage nextPage = (RoleSearchPage) cycle.getPage(RoleSearchPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doUserSubTab(IRequestCycle cycle) {
		UserSearchPage nextPage = (UserSearchPage) cycle.getPage(UserSearchPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doUserRoleSubTab(IRequestCycle cycle) {
		UserRoleSearchPage nextPage = (UserRoleSearchPage) cycle.getPage(UserRoleSearchPage.PAGE_NAME);
		nextPage.activate();
	}

}
