package jumpstart.max.web.components;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;

import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.ComponentClass;
import org.apache.tapestry.annotations.Parameter;
import org.joda.time.DateTime;
import org.joda.time.TimeOfDay;
import org.joda.time.base.AbstractInstant;
import org.joda.time.base.AbstractPartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@ComponentClass
public abstract class InsertDateTime extends AbstractComponent {

	@Parameter(name = "value", required = true)
	public abstract Object getValue();

	@Parameter(name = "style")
	public abstract String getStyle();

	@Parameter(name = "formatter", required = false)
	public abstract DateTimeFormatter getFormatter();

	@Parameter(name = "format", required = false)
	public abstract Format getFormat();

	@Parameter(name = "class")
	public abstract String getStyleClass();

	protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
		if (cycle.isRewinding())
			return;

		Object value = getValue();

		if (value == null)
			return;

		String style = getStyle();
		DateTimeFormatter formatter = getFormatter();
		Format format = getFormat();

		if (format != null) {
			throw new IllegalArgumentException(
					"InsertDateTime does not allow \"format\" parameter.  Valid parameters are \"style\" and \"formatter\".  Formatter type is DateTimeFormatter.");
		}

		if ((style != null) && (formatter != null)) {
			throw new IllegalArgumentException(
					"InsertDateTime can optionally receive \"style\" parameter or \"format\" parameter, but not both.  Received style=\""
							+ style + "\" and format=" + formatter + ".");
		}

		String insert = null;
		// If AbstractInstant - includes DateTime and DateMidnight
		if ((value instanceof AbstractInstant)) {
			AbstractInstant ai = ((AbstractInstant) value);
			if (style != null) {
				insert = DateTimeFormat.forStyle(style).print(ai);
			}
			else if (formatter != null) {
				insert = ai.toString(formatter);
			}
			else {
				insert = value.toString();
			}
		}
		// Else if AbstractPartial - includes LocalDate, LocalTime,
		// LocalDateTime, YearMonthDay, and TimeOfDay
		else if ((value instanceof AbstractPartial)) {
			AbstractPartial ap = ((AbstractPartial) value);
			if (style != null) {
				insert = DateTimeFormat.forStyle(style).print(ap);
			}
			else if (formatter != null) {
				insert = ap.toString(formatter);
			}
			else {
				insert = value.toString();
			}
		}
		else if (value instanceof Number) {
			DateTime dt = new DateTime(((Number) value).longValue());
			if (style != null) {
				insert = DateTimeFormat.forStyle(style).print(dt);
			}
			else if (formatter != null) {
				insert = dt.toString(formatter);
			}
			else {
				insert = value.toString();
			}
		}
		else if (value instanceof java.sql.Date) {
			DateTime dt = new DateTime(((Date) value).getTime());
			if (style != null) {
				insert = DateTimeFormat.forStyle(style).print(dt);
			}
			else if (formatter != null) {
				insert = dt.toString(formatter);
			}
			else {
				insert = value.toString();
			}
		}
		else if (value instanceof Timestamp) {
			DateTime dt = new DateTime(value);
			if (style != null) {
				insert = DateTimeFormat.forStyle(style).print(dt);
			}
			else if (formatter != null) {
				insert = dt.toString(formatter);
			}
			else {
				insert = value.toString();
			}
		}
		else if (value instanceof Time) {
			TimeOfDay tod = new TimeOfDay(value);
			if (style != null) {
				insert = DateTimeFormat.forStyle(style).print(tod);
			}
			else if (formatter != null) {
				insert = tod.toString(formatter);
			}
			else {
				insert = value.toString();
			}
		}
		// java.util.Date must be tested after java.sql.Date, Time, and
		// Timestamp, because they are subclasses
		else if (value instanceof java.util.Date) {
			DateTime dt = new DateTime(((Date) value).getTime());
			if (style != null) {
				insert = DateTimeFormat.forStyle(style).print(dt);
			}
			else if (formatter != null) {
				insert = dt.toString(formatter);
			}
			else {
				insert = value.toString();
			}
		}
		else {
			insert = ""; // or would null be OK?
		}

		String styleClass = getStyleClass();

		if (styleClass != null) {
			writer.begin("span");
			writer.attribute("class", styleClass);

			renderInformalParameters(writer, cycle);
		}

		writer.print(insert, true);

		if (styleClass != null)
			writer.end(); // <span/>
	}
}
