package jumpstart.max.web.components;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.ComponentClass;
import org.apache.tapestry.annotations.InjectObject;
import org.apache.tapestry.annotations.Parameter;
import org.apache.tapestry.web.WebContext;

@ComponentClass
public abstract class InsertSourceCode extends AbstractComponent {

	// The path of something in the WebContext
	// eg. "WEB-INF/pages/FirstPage.html

	@Parameter(name = "pathInWebapp", required = true)
	public abstract String getPathInWebapp();

	@Parameter(name = "pathInWebapp2", required = false)
	public abstract String getPathInWebapp2();

	// The path of some java source, relative to web/src/main/java/
	// eg. "jumpstart/min/web/pages/FirstPage.java

	@Parameter(name = "pathInWebJava", required = false)
	public abstract String getPathInWebJava();

	@Parameter(name = "pathInWebJava2", required = false)
	public abstract String getPathInWebJava2();

	// The path of some java source, relative to business/src/main/java/
	// eg. "jumpstart/min/business/commons/query/SearchOptions.java

	@Parameter(name = "pathInBusinessJava", required = false)
	public abstract String getPathInBusinessJava();

	@Parameter(name = "pathInBusinessJava2", required = false)
	public abstract String getPathInBusinessJava2();

	@InjectObject("service:tapestry.globals.WebContext")
	public abstract WebContext getWebContext();

	protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
		if (cycle.isRewinding())
			return;

		// Print start of the source block

		writer.println();
		writer.print("<!-- Start of source code inserted by @InsertSourceCode component. -->", true);
		writer.println();

		// Print a div with style info to make a pretty block

		writer.begin("div");
		String style = "font-family: Arial, Helvetica, sans-serif; font-size: 12px; font-weight: normal; background: #99ffcc; margin: 60px 0px 0px 0px; text-align: left; ";
		writer.attribute("style", style);
		writer.println();
		writer.print("Source code");
		writer.println();
		writer.beginEmpty("hr");
		writer.println();

		// Print the template source

		{
			InputStream templateStream = getWebContext().getResourceAsStream(getPathInWebapp());
			if (templateStream == null) {
				printResourceNotFound(writer, getPathInWebapp());
			}
			else {
				BufferedReader templateReader = new BufferedReader(new InputStreamReader(templateStream));
				printSource(writer, templateReader);
			}
		}

		// Print the specification source, if path provided

		if (getPathInWebapp2() != null) {
			writer.beginEmpty("hr");
			writer.println();

			InputStream specificationStream = getWebContext().getResourceAsStream(getPathInWebapp2());
			if (specificationStream == null) {
				printResourceNotFound(writer, getPathInWebapp2());
			}
			else {
				BufferedReader specificationReader = new BufferedReader(new InputStreamReader(specificationStream));
				printSource(writer, specificationReader);
			}
		}

		// Print the java source, if path provided

		if (getPathInWebJava() != null) {
			String realPath = getWebContext().getRealPath("../../../web/src/main/java/" + getPathInWebJava());
			printSource(writer, getPathInWebJava(), realPath);
		}
		
		if (getPathInWebJava2() != null) {
			String realPath = getWebContext().getRealPath("../../../web/src/main/java/" + getPathInWebJava2());
			printSource(writer, getPathInWebJava2(), realPath);
		}

		if (getPathInBusinessJava() != null) {
			String realPath = getWebContext().getRealPath("../../../business/src/main/java/" + getPathInBusinessJava());
			printSource(writer, getPathInBusinessJava(), realPath);
		}
		
		if (getPathInBusinessJava2() != null) {
			String realPath = getWebContext().getRealPath("../../../business/src/main/java/" + getPathInBusinessJava2());
			printSource(writer, getPathInBusinessJava2(), realPath);
		}
		
		writer.beginEmpty("hr");
		writer.println();

		// Print end of div

		writer.println();
		writer.end();

		// Print end of source block

		writer.println();
		writer.print("<!-- End of source code inserted by @InsertSourceCode component. -->", true);
		writer.println();
	}

	// Print the java source, if path provided

	private void printSource(IMarkupWriter writer, String givenPath, String realPath) {
		writer.beginEmpty("hr");
		writer.println();

		// Java source is outside the WAR so cannot get resource as stream -
		// use FileReader instead.

		try {
			BufferedReader javaReader = new BufferedReader(new FileReader(realPath));
			printSource(writer, javaReader);
		}
		catch (FileNotFoundException e) {
			writer.println();
			writer
					.print("The java source file was not found.  Note it will only be available if running from exploded EAR in the project directory, ie. not from a deployed EAR.");
			writer.beginEmpty("br");
			writer.println();
			writer.beginEmpty("br");
			writer.println();
			writer.print("Path given was " + givenPath);
			writer.beginEmpty("br");
			writer.println();
			writer.print("Path was expanded to: " + realPath);
			writer.println();
		}
	}

	private void printSource(IMarkupWriter writer, BufferedReader sourceReader) {
		writer.begin("pre");
		writer.println();
		writer.begin("code");
		writer.println();

		String s;
		try {
			while ((s = sourceReader.readLine()) != null) {
				writer.print(s);
				writer.println();
			}
		}
		catch (IOException e) {
			writer.print("Error reading .....?");
			e.printStackTrace();
		}

		writer.end();
		writer.println();
		writer.end();
		writer.println();
	}

	private void printResourceNotFound(IMarkupWriter writer, String resourcePath) {
		writer.println();
		writer.print("The file was not found.");
		writer.beginEmpty("br");
		writer.println();
		writer.beginEmpty("br");
		writer.println();
		writer.print("Path given was " + resourcePath);
		writer.beginEmpty("br");
		writer.println();
	}

}
