package jumpstart.max.web.pages.base;

import java.io.Serializable;
import java.text.Format;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import jumpstart.max.business.domain.security.UserRole;
import jumpstart.max.business.domain.security.iface.ISecurityFinderSvcLocal;
import jumpstart.max.web.commons.annotations.InjectPageLink;
import jumpstart.max.web.pages.login.LoginPage;
import jumpstart.max.web.state.Visit;

import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageValidateListener;
import org.apache.tapestry.form.translator.DateTranslator;

/**
 * Base page for pages that must not be accessible if the user is not logged in.
 */
public abstract class ProtectedBasePage extends SimpleBasePage implements PageValidateListener {
	static private final Long ROLE_SECOFRONLY = new Long(-2);
	static private final Long ROLE_ALL = new Long(-1);
	static private final Long ROLE_SECURITYOFFICER = new Long(1);
	static private final Long ROLE_ADMIN = new Long(2);
	static private final Long ROLE_ACCOUNTS = new Long(3);

	static private Set<String> _functionRightRoles = null;

	@InjectPageLink(LoginPage.PAGE_NAME)
	public abstract ILink getLoginPageLink();

	/**
	 * Validate that the user is logged in. If not logged in, then redirects to
	 * the login page. Tapestry will call this method because this class
	 * implements PageValidateListener. Tapestry calls this method just before
	 * showing the page to the user.
	 */
	public void pageValidate(PageEvent event) {

		// If you're not logged in, then we redirect to the login page.

		Visit myVisit = getMyVisit();
		if (myVisit == null || !myVisit.isLoggedIn()) {
			IRequestCycle cycle = event.getRequestCycle();
			LoginPage login = (LoginPage) cycle.getPage(LoginPage.PAGE_NAME);
			throw new PageRedirectException(login);
		}

	}

	//
	// Translators and Formatters
	// - they're tailored to the user, cached in the Visit
	//

	public DateTranslator getMyDateTranslator() {
		return getMyVisit().getMyDateTranslator();
	}

	public Format getMyDateViewFormat() {
		return getMyVisit().getMyDateViewFormat();
	}

	public Format getMyDateListFormat() {
		return getMyVisit().getMyDateListFormat();
	}

	public NumberFormat getCurrencyFormat() {
		return getMyVisit().getCurrencyFormat();
	}

	//
	// Authorisation
	// TODO - review. This implementation is all hard-coded.
	// A proper solution would be to soft-code in the database,
	// perhaps with an entity that represents FunctionRight and
	// another that represents the relationship between FunctionRight
	// and Role. And for true security, authorisation should be checked in the
	// business tier regardless of whether it's done in the web tier.
	//

	public boolean isAuthorised(String functionRight) {

		if (_functionRightRoles == null) {
			_functionRightRoles = new HashSet<String>();
			_functionRightRoles.add("Code_Search|" + ROLE_ALL.toString());
			_functionRightRoles.add("Code_View|" + ROLE_ALL.toString());
			_functionRightRoles.add("Code_Add|" + ROLE_ADMIN.toString());
			_functionRightRoles.add("Code_Edit|" + ROLE_ADMIN.toString());
			_functionRightRoles.add("Code_Remove|" + ROLE_ADMIN.toString());
			_functionRightRoles.add("CodeGroup_Search|" + ROLE_ALL.toString());
			_functionRightRoles.add("CodeGroup_View|" + ROLE_ALL.toString());
			_functionRightRoles.add("CodeGroup_Create|" + ROLE_ADMIN.toString());
			_functionRightRoles.add("CodeGroup_Edit|" + ROLE_ADMIN.toString());
			_functionRightRoles.add("CodeGroup_Delete|" + ROLE_ADMIN.toString());
			_functionRightRoles.add("ShowInspector_Edit|" + ROLE_ADMIN.toString());
			_functionRightRoles.add("My_Password_Change|" + ROLE_ALL.toString());
			_functionRightRoles.add("My_Profile_View|" + ROLE_ALL.toString());
			_functionRightRoles.add("My_Profile_Edit|" + ROLE_ALL.toString());
			_functionRightRoles.add("Options_Edit|" + ROLE_ALL.toString());
			_functionRightRoles.add("Role_Search|" + ROLE_ADMIN.toString());
			_functionRightRoles.add("Role_View|" + ROLE_ADMIN.toString());
			_functionRightRoles.add("Role_Create|" + ROLE_SECOFRONLY.toString());
			_functionRightRoles.add("Role_Edit|" + ROLE_SECOFRONLY.toString());
			_functionRightRoles.add("Role_Delete|" + ROLE_SECOFRONLY.toString());
			_functionRightRoles.add("User_Search|" + ROLE_ADMIN.toString());
			_functionRightRoles.add("User_Search|" + ROLE_ACCOUNTS.toString());
			_functionRightRoles.add("User_View|" + ROLE_ADMIN.toString());
			_functionRightRoles.add("User_View|" + ROLE_ACCOUNTS.toString());
			_functionRightRoles.add("User_Create|" + ROLE_SECOFRONLY.toString());
			_functionRightRoles.add("User_Edit|" + ROLE_ADMIN.toString());
			_functionRightRoles.add("User_Delete|" + ROLE_SECOFRONLY.toString());
			_functionRightRoles.add("UserRole_Search|" + ROLE_ADMIN.toString());
			_functionRightRoles.add("UserRole_View|" + ROLE_ADMIN.toString());
			_functionRightRoles.add("UserRole_Add|" + ROLE_SECOFRONLY.toString());
			_functionRightRoles.add("UserRole_Edit|" + ROLE_SECOFRONLY.toString());
			_functionRightRoles.add("UserRole_Remove|" + ROLE_SECOFRONLY.toString());
		}

		List<Long> myActiveRoleIds = getMyActiveRoleIds();

		// If I have "security oficer" role I can do anything

		if (myActiveRoleIds.contains(ROLE_SECURITYOFFICER)) {
			return true;
		}
		else {
			for (Long roleId : myActiveRoleIds) {
				String lookupKey = functionRight + "|" + roleId.toString();
				if (_functionRightRoles.contains(lookupKey)) {
					return true;
				}
			}
			String lookupKey = functionRight + "|" + ROLE_ALL.toString();
			if (_functionRightRoles.contains(lookupKey)) {
				return true;
			}
		}
		return false;
	}

	public boolean isAuthorised(String functionRight, Serializable id) {

		// This method allows for data rights checking.
		// TODO - review. In this simple implementation we only do function
		// rights checking.

		return isAuthorised(functionRight);
	}

	protected List<Long> getMyActiveRoleIds() {

		// TODO - review. This lazy loads the user's roles into the visit but
		// cannot keep them up-to-date.
		// It may be better to keep all user roles in a Session State Object
		// that is automatically refreshed by any function that maintains them.

		// Get my userRoles from the visit

		List<Long> myActiveRoleIds = getMyVisit().getMyActiveRoleIds();

		// If the visit doesn't have them, then get them from the security
		// finder and save them in the visit

		if (myActiveRoleIds == null) {
			ISecurityFinderSvcLocal finder = getBusinessServicesLocator().getSecurityFinderSvcLocal();
			List<UserRole> myRoles = finder.findUserRolesShallowishByUser(getMyVisit().getMyUserId());
			getMyVisit().setMyUserRoles(myRoles);
			myActiveRoleIds = getMyVisit().getMyActiveRoleIds();
		}

		return myActiveRoleIds;
	}

}
