package jumpstart.max.web.pages.examples.ajax;

import java.util.Date;

import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.html.BasePage;

public abstract class BasicAJAXPage extends BasePage {
	static public final String PAGE_NAME = "pages/examples/ajax/BasicAJAXPage";

	@Persist
	public abstract void setTime(Date value);

	public void activate() {
		doRefreshTime();
		getRequestCycle().activate(this);
	}

	public void doRefreshTime() {
		setTime(new Date());
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}
}