package jumpstart.max.web.pages.examples.ajax;

import java.util.Date;

import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.EventListener;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.html.BasePage;

public abstract class EventListenerPage extends BasePage {
	static public final String PAGE_NAME = "pages/examples/ajax/EventListenerPage";

	public abstract String getFirstName();

	public abstract String getLastName();

	public abstract void setEcho(String value);

	public abstract void setTime(Date value);

	@Persist
	public abstract void setTimeColor(String value);
	public abstract String getTimeColor();

	public void activate() {
		setEcho("");
		setTime(new Date());
		setTimeColor("black");
		getRequestCycle().activate(this);
	}

	@EventListener(targets = {"firstName", "lastName"}, events = "onchange")
	public void doEchoName(IRequestCycle cycle) {
		String firstName = getFirstName() == null ? "" : getFirstName().trim();
		String lastName = getLastName() == null ? "" : getLastName().trim();
		setEcho(firstName + " " + lastName);
		cycle.getResponseBuilder().updateComponent("echo");
	}

	@EventListener(targets = "time", events = "onmouseover")
	public void doRefreshTime(IRequestCycle cycle) {
		setTime(new Date());
		switchTimeColour();
		cycle.getResponseBuilder().updateComponent("time");
	}
	
	private void switchTimeColour() {
		if (getTimeColor().equals("black")) {
			setTimeColor("red");
		}
		else {
			setTimeColor("black");
		}
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}
}