package jumpstart.max.web.pages.examples.beanform;

import jumpstart.max.business.domain.examples.Person;
import jumpstart.max.business.domain.examples.iface.IExamplesServiceLocal;
import jumpstart.max.web.pages.login.LoginPage;
import jumpstart.max.web.state.BusinessServicesLocator;

import org.apache.tapestry.IAsset;
import org.apache.tapestry.annotations.Asset;
import org.apache.tapestry.annotations.Bean;
import org.apache.tapestry.annotations.InjectState;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.html.BasePage;
import org.apache.tapestry.valid.ValidationDelegate;

public abstract class BeanFormPage extends BasePage {
	static public final String PAGE_NAME = "pages/examples/beanform/BeanFormPage";

	@Bean
	// Beans get created and destroyed on the fly per request cycle
	public abstract ValidationDelegate getValidationDelegate();

	@Persist
	// We say Persist to tell Tapestry this isn't transient - we want it to
	// remember the entire Person object between output and input
	public abstract Person getPerson();
	public abstract void setPerson(Person value);

	@InjectState("businessServicesLocator")
	// businessServicesLocator locates our business services (which are EJB3 session
	// beans). It is an application-scoped object registered in hivemodule.xml.
	public abstract BusinessServicesLocator getBusinessServicesLocator();

	@Asset("context:/css/examples_client_val.css")
	public abstract IAsset getStylesheet();

	public void activate(Long personId) {

		// Ask business service to find the Person requested

		Person person = getExamplesService().findPerson(personId);
		if (person == null) {
			throw new IllegalStateException("Database data has not been set up!");
		}

		// Populate the page and flag it as the next one to activate

		setPerson(person);
		getRequestCycle().activate(this);
	}

	public void doSaveAndDisplay() {
		try {
			getExamplesService().changePerson(getPerson());

			BeanFormPage2 nextPage = (BeanFormPage2) getRequestCycle().getPage(BeanFormPage2.PAGE_NAME);
			nextPage.activate(getPerson().getId());
		}
		catch (Exception e) {
			getValidationDelegate().record(getRootCause(e), null);
			return;
		}
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}

	private IExamplesServiceLocal getExamplesService() {

		// Use our business services locator to get the EJB3 session bean called
		// "ExamplesServiceLocal".

		return getBusinessServicesLocator().getExamplesServiceLocal();
	}

	private String getRootCause(Throwable t) {
		Throwable cause = t;
		Throwable subCause = cause.getCause();
		while (subCause != null && !subCause.equals(cause)) {
			cause = subCause;
			subCause = cause.getCause();
		}
		return cause.getMessage();
	}
}