package jumpstart.max.web.pages.examples.beanform;

import jumpstart.max.business.domain.examples.Person;
import jumpstart.max.business.domain.examples.iface.IExamplesServiceLocal;
import jumpstart.max.web.pages.login.LoginPage;
import jumpstart.max.web.state.BusinessServicesLocator;

import org.apache.tapestry.annotations.InjectState;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.html.BasePage;

public abstract class BeanFormPage2 extends BasePage {
	static public final String PAGE_NAME = "pages/examples/beanform/BeanFormPage2";

	@Persist
	public abstract Person getPerson();
	public abstract void setPerson(Person value);

	@InjectState("businessServicesLocator")
	public abstract BusinessServicesLocator getBusinessServicesLocator();

	public void activate(Long personId) {
		Person person = getExamplesService().findPerson(personId);
		if (person == null) {
			throw new IllegalStateException("Database data has not been set up!");
		}
		setPerson(person);
		getRequestCycle().activate(this);
	}

	public void doReturn(Long personId) {
		BeanFormPage nextPage = (BeanFormPage) getRequestCycle().getPage(BeanFormPage.PAGE_NAME);
		nextPage.activate(getPerson().getId());
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}

	private IExamplesServiceLocal getExamplesService() {
		return getBusinessServicesLocator().getExamplesServiceLocal();
	}
}