package jumpstart.max.web.pages.examples.dupes;

import jumpstart.max.web.commons.annotations.InjectPageLink;
import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.IAsset;
import org.apache.tapestry.annotations.Asset;
import org.apache.tapestry.annotations.InjectState;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.html.BasePage;

public abstract class DoItOnceAndRedirectPage extends BasePage {
	static public final String PAGE_NAME = "pages/examples/dupes/DoItOnceAndRedirectPage";

	@InjectState("myOrder")
	// myOrder is a session-scoped object - see hivemodule.xml.
	public abstract MyOrder getMyOrder();

	@Asset("context:/images/action-button.png")
	public abstract IAsset getButtonImage();
	
	@InjectPageLink(DoItOnceAndRedirectPage2.PAGE_NAME)
	public abstract ILink getPage2Link();

	public void activate() {
		getRequestCycle().activate(this);
	}

	// Return an ILink, which tells Tapestry to do redirect-after-post
	public ILink doOrder(int orderQuantity) {
		sleep(2000); // Sleep 2 seconds to simulate busy system
		int newQuantity = getMyOrder().getQuantity() + orderQuantity;
		getMyOrder().setQuantity(newQuantity);
		return getPage2Link();
	}

	public void doRefresh() {
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}

	private void sleep(long duration) {
		try {
			Thread.sleep(duration);
		}
		catch (InterruptedException e) {
		}
	}
}